-- Boxenstop Database Schema
-- Für Volvo Autohaus Event-Management

CREATE DATABASE IF NOT EXISTS boxxenstopp;
USE boxxenstopp;

-- Tabelle für Boxenstop Events
CREATE TABLE events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    event_date DATE NOT NULL,
    start_time TIME NOT NULL,
    end_time TIME NOT NULL,
    slot_duration INT DEFAULT 30, -- Minuten pro Slot
    max_monteure INT DEFAULT 5,
    pause_start TIME NULL,
    pause_end TIME NULL,
    blocked_start TIME NULL,
    blocked_end TIME NULL,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabelle für Termine
CREATE TABLE appointments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    event_id INT NOT NULL,
    slot_time TIME NOT NULL,
    slot_date DATE NOT NULL,
    customer_name VARCHAR(255) NOT NULL,
    license_plate VARCHAR(20) NOT NULL,
    storage_number VARCHAR(50) NULL,
    brings_wheels BOOLEAN DEFAULT TRUE,
    wheels_storage_action ENUM('store', 'vehicle') DEFAULT 'store',
    seasonal_check ENUM('none', 'spring', 'winter') DEFAULT 'none',
    phone VARCHAR(20) NOT NULL,
    info_text TEXT NULL,
    has_wheel_lock BOOLEAN DEFAULT FALSE,
    wiper_blades BOOLEAN DEFAULT FALSE,
    status ENUM('pending', 'approved', 'rejected', 'rescheduled', 'booked', 'completed', 'cancelled') DEFAULT 'pending',
    order_number VARCHAR(50) NULL,
    admin_notes TEXT NULL,
    approved_by INT NULL,
    approved_at TIMESTAMP NULL,
    rejection_reason TEXT NULL,
    reschedule_reason TEXT NULL,
    tire_order_date TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (event_id) REFERENCES events(id) ON DELETE CASCADE,
    FOREIGN KEY (approved_by) REFERENCES admin_users(id) ON DELETE SET NULL
);

-- Tabelle für Einlagerungen
CREATE TABLE storage (
    id INT AUTO_INCREMENT PRIMARY KEY,
    storage_number VARCHAR(50) UNIQUE NOT NULL,
    customer_name VARCHAR(255) NOT NULL,
    license_plate VARCHAR(20) NOT NULL,
    phone VARCHAR(20) NOT NULL,
    storage_date DATE NOT NULL,
    status ENUM('stored', 'retrieved') DEFAULT 'stored',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabelle für Admin-Benutzer
CREATE TABLE admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password_hash VARCHAR(255) NOT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_login TIMESTAMP NULL
);

-- Tabelle für System-Einstellungen
CREATE TABLE settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT,
    description TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Standard-Einstellungen einfügen
INSERT INTO settings (setting_key, setting_value, description) VALUES
('company_name', 'Volvo Autohaus', 'Name des Unternehmens'),
('company_logo', 'assets/images/volvo-logo.png', 'Pfad zum Firmenlogo'),
('default_slot_duration', '30', 'Standard Slot-Dauer in Minuten'),
('max_monteure', '5', 'Maximale Anzahl Monteure'),
('contact_phone', '', 'Kontakttelefonnummer'),
('contact_email', '', 'Kontakt-E-Mail'),
('setup_completed', '0', 'Einrichtungsassistent abgeschlossen');

-- Standard Admin-Benutzer (Passwort: admin123)
INSERT INTO admin_users (username, email, password_hash) VALUES
('admin', 'admin@volvo-autohaus.de', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');
