-- API Security Tables (portable)

CREATE TABLE IF NOT EXISTS api_keys (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  key_hash CHAR(64) NOT NULL UNIQUE,
  secret_hash CHAR(64) NOT NULL,
  scopes TEXT NOT NULL,                       -- JSON-String als TEXT
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  rate_limit_per_min INT NOT NULL DEFAULT 60,
  owner_type VARCHAR(20) DEFAULT 'admin',     -- statt ENUM
  owner_id INT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  last_used_at TIMESTAMP NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS api_key_usage (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  api_key_id INT NOT NULL,
  endpoint VARCHAR(255) NOT NULL,
  http_method VARCHAR(10) NOT NULL,
  status_code INT NOT NULL,
  request_ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  ip VARCHAR(64) NULL,
  bytes_in INT DEFAULT 0,
  bytes_out INT DEFAULT 0,
  INDEX(api_key_id, request_ts),
  CONSTRAINT fk_usage_key FOREIGN KEY (api_key_id) REFERENCES api_keys(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS api_replay_nonce (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  api_key_id INT NOT NULL,
  nonce VARCHAR(64) NOT NULL,
  ts TIMESTAMP NOT NULL,
  UNIQUE KEY uq_nonce (api_key_id, nonce),
  CONSTRAINT fk_nonce_key FOREIGN KEY (api_key_id) REFERENCES api_keys(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
