-- WhatsApp-Felder zur Autohaus-Tabelle hinzufügen
-- Für HelloMateo API Integration

USE boxxenstopp;

-- WhatsApp-spezifische Felder zur Autohaus-Tabelle hinzufügen
ALTER TABLE autohaus 
ADD COLUMN whatsapp_notifications_enabled BOOLEAN DEFAULT FALSE AFTER teams_mention_users,
ADD COLUMN whatsapp_api_key VARCHAR(255) DEFAULT '' AFTER whatsapp_notifications_enabled,
ADD COLUMN whatsapp_phone_number VARCHAR(20) DEFAULT '' AFTER whatsapp_api_key,
ADD COLUMN whatsapp_business_name VARCHAR(255) DEFAULT '' AFTER whatsapp_phone_number,
ADD COLUMN whatsapp_template_id VARCHAR(100) DEFAULT '' AFTER whatsapp_business_name,
ADD COLUMN whatsapp_test_mode BOOLEAN DEFAULT TRUE AFTER whatsapp_template_id;

-- WhatsApp-Erinnerungsfelder zur Appointments-Tabelle hinzufügen
ALTER TABLE appointments 
ADD COLUMN whatsapp_reminder_sent BOOLEAN DEFAULT FALSE AFTER reschedule_reason,
ADD COLUMN whatsapp_reminder_sent_at TIMESTAMP NULL AFTER whatsapp_reminder_sent;

-- Indizes für bessere Performance
CREATE INDEX IF NOT EXISTS idx_appointments_whatsapp_reminder ON appointments(whatsapp_reminder_sent, slot_date);
CREATE INDEX IF NOT EXISTS idx_autohaus_whatsapp_enabled ON autohaus(whatsapp_notifications_enabled);

-- Kommentare hinzufügen
ALTER TABLE autohaus 
MODIFY COLUMN whatsapp_notifications_enabled BOOLEAN DEFAULT FALSE COMMENT 'WhatsApp-Benachrichtigungen für dieses Autohaus aktiviert',
MODIFY COLUMN whatsapp_api_key VARCHAR(255) DEFAULT '' COMMENT 'HelloMateo API-Key für WhatsApp-Nachrichten',
MODIFY COLUMN whatsapp_phone_number VARCHAR(20) DEFAULT '' COMMENT 'WhatsApp-Geschäftsnummer für dieses Autohaus',
MODIFY COLUMN whatsapp_business_name VARCHAR(255) DEFAULT '' COMMENT 'Geschäftsname für WhatsApp-Nachrichten',
MODIFY COLUMN whatsapp_template_id VARCHAR(100) DEFAULT '' COMMENT 'HelloMateo Template-ID für strukturierte Nachrichten',
MODIFY COLUMN whatsapp_test_mode BOOLEAN DEFAULT TRUE COMMENT 'Test-Modus für WhatsApp-Nachrichten (keine echten Nachrichten)';

ALTER TABLE appointments 
MODIFY COLUMN whatsapp_reminder_sent BOOLEAN DEFAULT FALSE COMMENT 'WhatsApp-Erinnerung für diesen Termin gesendet',
MODIFY COLUMN whatsapp_reminder_sent_at TIMESTAMP NULL COMMENT 'Zeitpunkt der gesendeten WhatsApp-Erinnerung';

-- Standard-Werte für bestehende Autohäuser setzen
UPDATE autohaus 
SET whatsapp_business_name = name 
WHERE whatsapp_business_name = '';

-- Log-Tabelle für WhatsApp-Nachrichten erstellen
CREATE TABLE IF NOT EXISTS whatsapp_message_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    autohaus_id INT,
    appointment_id INT NULL,
    recipient_phone VARCHAR(20) NOT NULL,
    message_type ENUM('appointment_approved', 'appointment_rejected', 'appointment_rescheduled', 'reminder', 'test') NOT NULL,
    message_content TEXT NOT NULL,
    api_response JSON NULL,
    success BOOLEAN NOT NULL,
    error_message TEXT NULL,
    sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_appointment_id (appointment_id),
    INDEX idx_recipient_phone (recipient_phone),
    INDEX idx_message_type (message_type),
    INDEX idx_success (success),
    INDEX idx_sent_at (sent_at),
    
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE SET NULL,
    FOREIGN KEY (appointment_id) REFERENCES appointments(id) ON DELETE SET NULL
);

-- Beispiel-Daten für WhatsApp-Log
INSERT INTO whatsapp_message_log (autohaus_id, recipient_phone, message_type, message_content, success, sent_at) VALUES
(1, '+49123456789', 'test', 'Test-Nachricht für WhatsApp-Integration', TRUE, NOW()),
(2, '+49987654321', 'test', 'Test-Nachricht für WhatsApp-Integration', TRUE, NOW());

-- Erfolgreiche Migration melden
SELECT 'WhatsApp-Felder erfolgreich zur Autohaus-Tabelle hinzugefügt' as status;
