<?php
/**
 * Datenbank-Updates anwenden
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "Starte Datenbank-Updates...\n";
    
    // 1. E-Mail-Spalte hinzufügen
    try {
        $conn->exec("ALTER TABLE appointments ADD COLUMN email VARCHAR(255) NULL AFTER phone");
        echo "✅ E-Mail-Spalte hinzugefügt\n";
    } catch (Exception $e) {
        echo "⚠️ E-Mail-Spalte bereits vorhanden oder Fehler: " . $e->getMessage() . "\n";
    }
    
    // 2. Weitere Spalten hinzufügen
    $columns = [
        "wiper_blades BOOLEAN DEFAULT FALSE AFTER has_wheel_lock",
        "order_number VARCHAR(50) NULL AFTER status",
        "admin_notes TEXT NULL AFTER order_number",
        "approved_by INT NULL AFTER admin_notes",
        "approved_at TIMESTAMP NULL AFTER approved_at",
        "rejection_reason TEXT NULL AFTER approved_at",
        "reschedule_reason TEXT NULL AFTER rejection_reason",
        "tire_order_date TIMESTAMP NULL AFTER reschedule_reason"
    ];
    
    foreach ($columns as $column) {
        try {
            $conn->exec("ALTER TABLE appointments ADD COLUMN $column");
            echo "✅ Spalte hinzugefügt: $column\n";
        } catch (Exception $e) {
            echo "⚠️ Spalte bereits vorhanden: $column\n";
        }
    }
    
    // 3. Status ENUM erweitern
    try {
        $conn->exec("ALTER TABLE appointments MODIFY COLUMN status ENUM('pending', 'approved', 'rejected', 'rescheduled', 'booked', 'completed', 'cancelled') DEFAULT 'pending'");
        echo "✅ Status ENUM erweitert\n";
    } catch (Exception $e) {
        echo "⚠️ Status ENUM Fehler: " . $e->getMessage() . "\n";
    }
    
    // 4. Foreign Key hinzufügen
    try {
        $conn->exec("ALTER TABLE appointments ADD CONSTRAINT fk_appointments_approved_by FOREIGN KEY (approved_by) REFERENCES admin_users(id) ON DELETE SET NULL");
        echo "✅ Foreign Key hinzugefügt\n";
    } catch (Exception $e) {
        echo "⚠️ Foreign Key bereits vorhanden oder Fehler: " . $e->getMessage() . "\n";
    }
    
    // 5. Indizes hinzufügen
    $indexes = [
        "idx_appointments_status ON appointments(status)",
        "idx_appointments_approved_by ON appointments(approved_by)",
        "idx_appointments_created_at ON appointments(created_at)",
        "idx_appointments_email ON appointments(email)"
    ];
    
    foreach ($indexes as $index) {
        try {
            $conn->exec("CREATE INDEX $index");
            echo "✅ Index erstellt: $index\n";
        } catch (Exception $e) {
            echo "⚠️ Index bereits vorhanden: $index\n";
        }
    }
    
    // 6. Einstellungen hinzufügen
    $settings = [
        "('appointment_approval_required', '1', 'Terminbestätigung durch Admin erforderlich')",
        "('email_notifications_enabled', '1', 'E-Mail-Benachrichtigungen aktiviert')",
        "('auto_approve_appointments', '0', 'Termine automatisch genehmigen')",
        "('appointment_reminder_days', '1,3,7', 'Erinnerungstage vor Termin (kommagetrennt)')",
        "('smtp_server', 'smtp-mail.outlook.com', 'SMTP-Server')",
        "('smtp_port', '587', 'SMTP-Port')",
        "('smtp_username', 'rentacar-kiel@be-automobile.de', 'SMTP-Benutzername')",
        "('smtp_password', 'W@050373011206af', 'SMTP-Passwort')",
        "('smtp_use_tls', '1', 'SMTP TLS verwenden')",
        "('smtp_use_ssl', '0', 'SMTP SSL verwenden')",
        "('mail_from_email', 'rentacar-kiel@be-automobile.de', 'Absender-E-Mail')",
        "('mail_from_name', 'Boxenstop Volvo Service', 'Absender-Name')"
    ];
    
    foreach ($settings as $setting) {
        try {
            $conn->exec("INSERT INTO settings (setting_key, setting_value, description) VALUES $setting ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value), description = VALUES(description)");
            echo "✅ Einstellung hinzugefügt: $setting\n";
        } catch (Exception $e) {
            echo "⚠️ Einstellung Fehler: " . $e->getMessage() . "\n";
        }
    }
    
    // 7. Bestehende Termine auf 'approved' setzen (da sie bereits gebucht waren)
    try {
        $result = $conn->exec("UPDATE appointments SET status = 'approved' WHERE status = 'booked'");
        echo "✅ $result bestehende Termine auf 'approved' gesetzt\n";
    } catch (Exception $e) {
        echo "⚠️ Update bestehender Termine Fehler: " . $e->getMessage() . "\n";
    }
    
    // 8. Für Termine ohne E-Mail Platzhalter setzen
    try {
        $result = $conn->exec("UPDATE appointments SET email = CONCAT('kunde-', id, '@boxxenstopp.local') WHERE email IS NULL OR email = ''");
        echo "✅ $result Termine mit Platzhalter-E-Mail versehen\n";
    } catch (Exception $e) {
        echo "⚠️ E-Mail-Platzhalter Fehler: " . $e->getMessage() . "\n";
    }
    
    echo "\n🎉 Datenbank-Updates erfolgreich abgeschlossen!\n";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
}
?>
