<?php
/**
 * Verifikationsdokument hochladen
 */
session_start();
require_once 'config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Prüfe ob User eingeloggt ist
    if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
        throw new Exception('Nicht angemeldet');
    }
    
    $user_id = $_SESSION['user_id'];
    
    // Prüfe ob Datei hochgeladen wurde
    if (!isset($_FILES['verification_document']) || $_FILES['verification_document']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Keine Datei hochgeladen');
    }
    
    $file = $_FILES['verification_document'];
    
    // Validierung
    $allowed_types = ['image/jpeg', 'image/png', 'image/jpg', 'application/pdf'];
    $max_size = 5 * 1024 * 1024; // 5MB
    
    if (!in_array($file['type'], $allowed_types)) {
        throw new Exception('Nur JPEG, PNG oder PDF Dateien erlaubt');
    }
    
    if ($file['size'] > $max_size) {
        throw new Exception('Datei zu groß (max. 5MB)');
    }
    
    // Upload-Verzeichnis erstellen
    $upload_dir = '../uploads/verification_documents/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    // Eindeutiger Dateiname
    $file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $filename = 'user_' . $user_id . '_' . time() . '.' . $file_extension;
    $filepath = $upload_dir . $filename;
    
    // Datei verschieben
    if (!move_uploaded_file($file['tmp_name'], $filepath)) {
        throw new Exception('Fehler beim Hochladen der Datei');
    }
    
    // In Datenbank speichern
    $relative_path = 'uploads/verification_documents/' . $filename;
    
    $stmt = $pdo->prepare("UPDATE users SET verification_document = ?, verification_status = 'pending', updated_at = NOW() WHERE id = ?");
    $stmt->execute([$relative_path, $user_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Verifikationsdokument erfolgreich hochgeladen',
        'document_path' => $relative_path
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
