<?php
session_start();

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Admin-Check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $autohaus_id = intval($_POST['autohaus_id'] ?? 0);
    $image_alt = trim($_POST['image_alt'] ?? '');
    
    if ($autohaus_id <= 0) {
        throw new Exception('Ungültige Autohaus-ID');
    }
    
    // Prüfe ob Autohaus existiert
    $stmt = $conn->prepare("SELECT id FROM autohaus WHERE id = ?");
    $stmt->execute([$autohaus_id]);
    if (!$stmt->fetch()) {
        throw new Exception('Autohaus nicht gefunden');
    }
    
    // Upload-Verzeichnis erstellen
    $uploadDir = '../uploads/autohaus_footer/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }
    
    // Datei hochladen
    if (!isset($_FILES['footer_image']) || $_FILES['footer_image']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Keine Datei hochgeladen');
    }
    
    $file = $_FILES['footer_image'];
    $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/webp'];
    $maxSize = 5 * 1024 * 1024; // 5MB
    
    if (!in_array($file['type'], $allowedTypes)) {
        throw new Exception('Ungültiger Dateityp. Nur JPG, PNG und WEBP erlaubt.');
    }
    
    if ($file['size'] > $maxSize) {
        throw new Exception('Datei ist zu groß. Maximum: 5MB');
    }
    
    // Altes Bild löschen falls vorhanden
    $stmt = $conn->prepare("SELECT footer_image FROM autohaus WHERE id = ?");
    $stmt->execute([$autohaus_id]);
    $oldImage = $stmt->fetchColumn();
    if ($oldImage && file_exists('../' . $oldImage)) {
        unlink('../' . $oldImage);
    }
    
    // Neuen Dateinamen generieren
    $fileExtension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $fileName = 'autohaus_' . $autohaus_id . '_' . time() . '.' . $fileExtension;
    $uploadPath = $uploadDir . $fileName;
    
    // Datei hochladen
    if (!move_uploaded_file($file['tmp_name'], $uploadPath)) {
        throw new Exception('Fehler beim Hochladen der Datei');
    }
    
    // Pfad für DB speichern
    $relativePath = 'uploads/autohaus_footer/' . $fileName;
    
    // In Datenbank aktualisieren
    $stmt = $conn->prepare("UPDATE autohaus SET footer_image = ?, footer_image_alt = ? WHERE id = ?");
    $stmt->execute([$relativePath, $image_alt, $autohaus_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Bild erfolgreich hochgeladen',
        'image_path' => $relativePath,
        'image_url' => '/' . $relativePath
    ]);
    
} catch (\Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

