<?php
// Minimale API für Test
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

// Simuliere die echte API
$response = [
    'success' => true,
    'data' => [
        'einlagerungsnummer' => '9.716.991',
        'reifen_vl' => [
            'volltext' => 'Bridgestone Blizzak LM005 235/50R18'
        ]
    ],
    'timestamp' => date('Y-m-d H:i:s')
];

echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>
