<?php
/**
 * Einfacher Image Proxy ohne Session-Komplexität
 * Gibt immer ein Platzhalter-Bild aus
 */

header('Content-Type: image/png');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Hole Parameter
$lgfotoId = $_GET['lgfoto_id'] ?? 'unknown';
$appointmentId = $_GET['appointment_id'] ?? 'unknown';

// Erstelle ein einfaches Platzhalter-Bild
$image = imagecreate(120, 90);
$bgColor = imagecolorallocate($image, 240, 240, 240);
$textColor = imagecolorallocate($image, 100, 100, 100);
$borderColor = imagecolorallocate($image, 200, 200, 200);

// Hintergrund
imagefill($image, 0, 0, $bgColor);

// Rahmen
imagerectangle($image, 0, 0, 119, 89, $borderColor);

// Text hinzufügen
imagestring($image, 2, 10, 20, 'Bild nicht', $textColor);
imagestring($image, 2, 10, 35, 'verfugbar', $textColor);
imagestring($image, 1, 5, 55, 'ID: ' . $lgfotoId, $textColor);
imagestring($image, 1, 5, 70, 'Platzhalter', $textColor);

// Ausgabe
imagepng($image);
imagedestroy($image);
?>
