<?php
/**
 * RESY Data Extraction API - Sample HTML Version
 * Verwendet das echte HTML-Beispiel für die Extraktion
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Error handling
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Debug-Logging-Funktion
function debugLog($message) {
    $logFile = __DIR__ . '/../logs/resy_extraction.log';
    $timestamp = date('Y-m-d H:i:s');
    $logDir = dirname($logFile);
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND | LOCK_EX);
}

// Das echte HTML-Beispiel aus der User-Nachricht
function getSampleHtml() {
    return '<div class="main">
            <div class="container">
                <div class="data">
                  <h1 class="headerTitle">Übersicht Räder</h1>
                  
  <div id="Messages">
      </div>
  
  <div class="Data">
  
    <div id="infobox">
   
      <fieldset><legend>Einlagerungsinformationen</legend><div><label for="WheelLGS_ID" class="Label">Satznummer: </label><p id="WheelLGS_ID" name="" class="InputNormal"><b>9.718.476 </b></p></div><div><label for="WheelEINGANG" class="Label">Eingangsdatum: </label><p id="WheelEINGANG" name="" class="InputNormal"><b>10.04.2025</b></p></div><div><label for="WheelSERV_ID" class="Label">Serviceart: </label><p id="WheelSERV_ID" name="" class="InputNormal"><b>Lagern, Reinigen, Prüfen</b></p></div><div><label for="WheelAUSGANG" class="Label">Ausgangsdatum: </label><p id="WheelAUSGANG" name="" class="InputNormal"><b></b></p></div><div><label for="WheelKD_ID" class="Label">Autohaus: </label><p id="WheelKD_ID" name="" class="InputNormal"><b>113 B &amp; E / Kiel</b></p></div><form action="./index.php?m=wheelset&amp;a=edit" method="post" name="KundenBemerk" onsubmit="disableButtons(this); return true;"><input type="hidden" name="FN" value="KundenBemerk"><input type="hidden" name="LGS_ID" value="9718476"><div class="KDBemerk"><div><label for="WheelKDBEMERK" class="Label">Bemerkung: </label><textarea type="text" name="KDBEMERK" cols="30" rows="5" class="InputNormal">4 Neue Reifen Empfohlen einseitig abgefahren, Schnittverletzungen, Erhöhter verschleiß innen. Achsvermessung empfohlen.

07.08.2025 DVH</textarea></div></div><button type="submit" class="ButtonSubmit" name="button" value="submit">Ändern</button></form><div class="pdfDownload"><a href="./index.php?m=checkreport&amp;a=download&amp;PRUFDOC_ID=184793&amp;FN=WheelsetResult"><img src="./application/view/img/pdf-file.png" alt="Prüfbericht"> Prüfbericht</a></div></fieldset><fieldset><legend>Fahrzeugdaten</legend><div><label for="WheelKENNZEICHEN" class="Label">Kennzeichen: </label><p id="WheelKENNZEICHEN" name="" class="InputNormal"><b>KI-CK2010</b></p></div><div><label for="WheelFAHRGESTNR" class="Label">FIN: </label><p id="WheelFAHRGESTNR" name="" class="InputNormal"><b>YV1DZA5C6H2115964</b></p></div><div><label for="WheelBEZEICHNUNG" class="Label">Fzg. Bezeichnung: </label><p id="WheelBEZEICHNUNG" name="" class="InputNormal"><b></b></p></div><div><label for="WheelANREDE_ID" class="Label">Anrede: </label><p id="WheelANREDE_ID" name="" class="InputNormal"><b></b></p></div><div><label for="WheelHALTERNAME" class="Label">Haltername: </label><p id="WheelHALTERNAME" name="" class="InputNormal"><b>Cornelius+Krage Ra Partg mbb</b></p></div><div><label for="WheelSTRASS1" class="Label">Straße: </label><p id="WheelSTRASS1" name="" class="InputNormal"><b></b></p></div><div><label for="WheelORT" class="Label">Ort: </label><p id="WheelORT" name="" class="InputNormal"><b></b></p></div><div><label for="WheelTELEFON1" class="Label">Telefon: </label><p id="WheelTELEFON1" name="" class="InputNormal"><b></b></p></div><div><label for="WheelFAX" class="Label">Fax: </label><p id="WheelFAX" name="" class="InputNormal"><b></b></p></div><div><label for="WheelEMAIL" class="Label">E-Mail: </label><p id="WheelEMAIL" name="" class="InputNormal"><b></b></p></div><div class="fahrzeugeLink"><a href="./index.php?m=fahrzeuge&amp;a=edit&amp;FZG_ID=517873&amp;FN=FahrzeugDetails">Fahrzeugdaten anzeigen / ändern</a></div></fieldset><fieldset><legend>Rücklieferungen und Expresslieferung</legend>        <div id="RaderDeatailsButton">
             <a href="./index.php?m=wheelset&amp;a=order_cart&amp;LGS_ID=9718476&amp;FN=WheelsetResult" onclick="addIdToCart(9718476, &quot;lgsCart&quot;); this.style.visibility=&quot;hidden&quot;; return false;"><button id="ButtonDetailsOrderCart" type="button" class="ButtonSubmit">Zur Rücklieferung bestellen</button></a><a href="./index.php?m=wheelset&amp;a=order_now&amp;LGS_ID=9718476&amp;FN=WheelsetResult" onclick="addIdToCart(9718476, &quot;lgsCart&quot;); return true;"><button id="ButtonDetailsOrderNow" type="button" class="ButtonSubmit">Sofort bestellen</button></a>        </div>
    
        <div id="RaderDetailsLadestelle">
          <div><label for="WheelRUECKLIEFERTERMIN" class="Label">Rückliefertermin: </label><p id="WheelRUECKLIEFERTERMIN" name="" class="InputNormal"><b></b></p></div><div><label for="wheelsRUECK.LADESTELLE" class="Label">Ladestelle: </label><p id="wheelsRUECK.LADESTELLE" name="" class="InputNormal"><b></b></p></div><div><label for="WheelRUECKAKTBEMERKUNG" class="Label">Rückgabe Bemerkung: </label><p id="WheelRUECKAKTBEMERKUNG" name="" class="InputNormal"><b></b></p></div>        </div>
      
        </fieldset>  <div><table id="WheelsetViewWheels" class="ResultTable" name="WheelsetViewWheels"><caption>Geprüfte Räder</caption><colgroup><col class="DataCol" id="WheelsetViewWheelsPOS_IDDataCol"><col class="DataCol" id="WheelsetViewWheelsRFGROSSFMTDataCol"><col class="DataCol" id="WheelsetViewWheelsRFLOADINDXDataCol"><col class="DataCol" id="WheelsetViewWheelsRFLOADINDX2DataCol"><col class="DataCol" id="WheelsetViewWheelsSPEEDINDEXDataCol"><col class="DataCol" id="WheelsetViewWheelsRFHERST_IDDataCol"><col class="DataCol" id="WheelsetViewWheelsRFMODELL_IDDataCol"><col class="DataCol" id="WheelsetViewWheelsHERSTKENN_IDDataCol"><col class="DataCol" id="WheelsetViewWheelsDOTDataCol"><col class="DataCol" id="WheelsetViewWheelsPROFILDataCol"><col class="DataCol" id="WheelsetViewWheelsRUNFLAT_FLGDataCol"><col class="DataCol" id="WheelsetViewWheelsREIFEN_IDDataCol"><col class="DataCol" id="WheelsetViewWheelsFELGEN_IDDataCol"><col class="DataCol" id="WheelsetViewWheelsEMPFEHL_IDDataCol"></colgroup><thead><tr><th scope="col" align="left" class="DataCol ignore_case sort_string" title="Aufwärts sortieren" style="cursor: pointer;">Position<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▼</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Reifengröße<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="right" class="DataCol locale_de" style="cursor: pointer;">L1<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="right" class="DataCol locale_de" style="cursor: pointer;">L2<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">SI<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Reifenhersteller<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Reifenmodell<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Herstellerkennung<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">DOT<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="right" class="DataCol locale_de" style="cursor: pointer;">Profil<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Notlaufeigenschaften<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Reifenart<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Felgenart<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th><th scope="col" align="left" class="DataCol ignore_case sort_string" style="cursor: pointer;">Empfehlung<span style="font-family: Arial; font-size: 80%; visibility: hidden;">▲</span></th></tr></thead><tfoot><tr class="tablestatfooter"><td align="left" class="DataCol">Anz= 4</td><td align="left" class="DataCol">&nbsp;</td><td align="right" class="DataCol">&nbsp;</td><td align="right" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="right" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">&nbsp;</td></tr><tr></tr></tfoot><tbody><tr class="WheelsBad"><td align="left" class="DataCol">VL</td><td align="left" class="DataCol">235/55R19</td><td align="right" class="DataCol">105 </td><td align="right" class="DataCol">&nbsp;</td><td align="left" class="DataCol">V</td><td align="left" class="DataCol">Dunlop</td><td align="left" class="DataCol">WINTER SPORT 5 SUV</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">2821</td><td align="right" class="DataCol">3,5 mm</td><td align="left" class="DataCol">N</td><td align="left" class="DataCol">Winterreifen</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">Austausch notwendig</td></tr><tr class="WheelsWarn"><td align="left" class="DataCol">VR</td><td align="left" class="DataCol">235/55R19</td><td align="right" class="DataCol">105 </td><td align="right" class="DataCol">&nbsp;</td><td align="left" class="DataCol">V</td><td align="left" class="DataCol">Dunlop</td><td align="left" class="DataCol">WINTER SPORT 5 SUV</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">2821</td><td align="right" class="DataCol">4,1 mm</td><td align="left" class="DataCol">N</td><td align="left" class="DataCol">Winterreifen</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">leichte Fehler</td></tr><tr class="WheelsWarn"><td align="left" class="DataCol">HL</td><td align="left" class="DataCol">235/55R19</td><td align="right" class="DataCol">105 </td><td align="right" class="DataCol">&nbsp;</td><td align="left" class="DataCol">V</td><td align="left" class="DataCol">Dunlop</td><td align="left" class="DataCol">WINTER SPORT 5 SUV</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">2821</td><td align="right" class="DataCol">5,1 mm</td><td align="left" class="DataCol">N</td><td align="left" class="DataCol">Winterreifen</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">leichte Fehler</td></tr><tr class="WheelsGood"><td align="left" class="DataCol">HR</td><td align="left" class="DataCol">235/55R19</td><td align="right" class="DataCol">105 </td><td align="right" class="DataCol">&nbsp;</td><td align="left" class="DataCol">V</td><td align="left" class="DataCol">Dunlop</td><td align="left" class="DataCol">WINTER SPORT 5 SUV</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">2821</td><td align="right" class="DataCol">5,0 mm</td><td align="left" class="DataCol">N</td><td align="left" class="DataCol">Winterreifen</td><td align="left" class="DataCol">&nbsp;</td><td align="left" class="DataCol">keine Fehler</td></tr></tbody></table></div><div id="raderBox"><div id="raderUbersicht"><div id="linkbox"><div id="VL"><div class="header-title">VL</div><div id="Ubersinfos"><div id="UbersPosition"><div id="Profilinnen"><div><label for="RadProfilinnen" class="Label">I: </label><p id="RadProfilinnen" name="" class="InputNormal"><b>4,0 mm</b></p></div></div><div id="Profilmitte"><div><label for="RadProfilmitte" class="Label">M: </label><p id="RadProfilmitte" name="" class="InputNormal"><b>3,5 mm</b></p></div></div><div id="Profilaussen"><div><label for="RadProfilaussen" class="Label">A: </label><p id="RadProfilaussen" name="" class="InputNormal"><b>3,6 mm</b></p></div></div></div><div id="UbersAustausch"> X</div><div id="popupInfos"><div id="tooltipBox"><div class="RundFtittle">  Rad- und Felgenfehler </div><ol><li><p id="RadUndFelgen" name="" class="InputNormal"><b>Schnittverletzung</b></p></li><li><p id="RadUndFelgen" name="" class="InputNormal"><b></b></p></li><li><p id="RadUndFelgen" name="" class="InputNormal"><b>Erhöhter Verschleiß der Innenschulter</b></p></li><li><p id="RadUndFelgen" name="" class="InputNormal"><b>Auswaschung</b></p></li></ol><div id="EmpfehlungReifen"><div><label for="RFEMPFEHL_ID" class="Label">Empfehlung Reifen: </label><p id="RFEMPFEHL_ID" name="" class="InputNormal"><b>Austausch notwendig</b></p></div></div><div id="EmpfehlungFelgen"><div><label for="FGEMPFEHL_ID" class="Label">Empfehlung Felgen: </label><p id="FGEMPFEHL_ID" name="" class="InputNormal"><b>keine Fehler</b></p></div></div><div id="EmpfehlungPrüfergebnis"><div><label for="EMPFEHL_ID" class="Label">Empfehlung: </label><p id="EMPFEHL_ID" name="" class="InputNormal"><b>Austausch notwendig</b></p></div></div></div></div></div></div><div id="HL"><div class="header-title">HL</div><div id="Ubersinfos"><div id="UbersPosition"><div id="Profilinnen"><div><label for="RadProfilinnen" class="Label">I: </label><p id="RadProfilinnen" name="" class="InputNormal"><b>5,7 mm</b></p></div></div><div id="Profilmitte"><div><label for="RadProfilmitte" class="Label">M: </label><p id="RadProfilmitte" name="" class="InputNormal"><b>5,1 mm</b></p></div></div><div id="Profilaussen"><div><label for="RadProfilaussen" class="Label">A: </label><p id="RadProfilaussen" name="" class="InputNormal"><b>5,2 mm</b></p></div></div></div><div id="UbersLeichteFehler"> X</div><div id="popupInfos"><div class="RundFtittle">  Rad- und Felgenfehler </div><ol><li><p id="RadUndFelgen" name="" class="InputNormal"><b>Erhöhter Verschleiß der Innenschulter</b></p></li></ol><div id="EmpfehlungReifen"><div><label for="RFEMPFEHL_ID" class="Label">Empfehlung Reifen: </label><p id="RFEMPFEHL_ID" name="" class="InputNormal"><b>leichte Fehler</b></p></div></div><div id="EmpfehlungFelgen"><div><label for="FGEMPFEHL_ID" class="Label">Empfehlung Felgen: </label><p id="FGEMPFEHL_ID" name="" class="InputNormal"><b>keine Fehler</b></p></div></div><div id="EmpfehlungPrüfergebnis"><div><label for="EMPFEHL_ID" class="Label">Empfehlung: </label><p id="EMPFEHL_ID" name="" class="InputNormal"><b>leichte Fehler</b></p></div></div></div></div></div><div id="mittebox">
                          <img src="./application/view/img/resyauto.png" alt="resy auto" class="carImage">           
                 </div><div id="rechtbox"><div id="VR"><div class="header-title">VR</div><div id="Ubersinfos"><div id="UbersPosition"><div id="Profilinnen"><div><label for="RadProfilinnen" class="Label">I: </label><p id="RadProfilinnen" name="" class="InputNormal"><b>4,8 mm</b></p></div></div><div id="Profilmitte"><div><label for="RadProfilmitte" class="Label">M: </label><p id="RadProfilmitte" name="" class="InputNormal"><b>4,1 mm</b></p></div></div><div id="Profilaussen"><div><label for="RadProfilaussen" class="Label">A: </label><p id="RadProfilaussen" name="" class="InputNormal"><b>4,7 mm</b></p></div></div></div><div id="UbersLeichteFehler">X</div><div id="popupInfos"><div class="RundFtittle">  Rad- und Felgenfehler </div><ol><li><p id="RadUndFelgen" name="" class="InputNormal"><b>Erhöhter Verschleiß der Innenschulter</b></p></li></ol><div id="EmpfehlungReifen"><div><label for="RFEMPFEHL_ID" class="Label">Empfehlung Reifen: </label><p id="RFEMPFEHL_ID" name="" class="InputNormal"><b>leichte Fehler</b></p></div></div><div id="EmpfehlungFelgen"><div><label for="FGEMPFEHL_ID" class="Label">Empfehlung Felgen: </label><p id="FGEMPFEHL_ID" name="" class="InputNormal"><b>keine Fehler</b></p></div></div><div id="EmpfehlungPrüfergebnis"><div><label for="EMPFEHL_ID" class="Label">Empfehlung: </label><p id="EMPFEHL_ID" name="" class="InputNormal"><b>leichte Fehler</b></p></div></div></div></div></div><div id="HR"><div class="header-title">HR</div><div id="Ubersinfos"><div id="UbersPosition"><div id="Profilinnen"><div><label for="RadProfilinnen" class="Label">I: </label><p id="RadProfilinnen" name="" class="InputNormal"><b>5,4 mm</b></p></div></div><div id="Profilmitte"><div><label for="RadProfilmitte" class="Label">M: </label><p id="RadProfilmitte" name="" class="InputNormal"><b>5,0 mm</b></p></div></div><div id="Profilaussen"><div><label for="RadProfilaussen" class="Label">A: </label><p id="RadProfilaussen" name="" class="InputNormal"><b>5,3 mm</b></p></div></div></div><div id="UberskeinFehler"> X</div><div id="popupInfos"><div id="EmpfehlungReifen"><div><label for="RFEMPFEHL_ID" class="Label">Empfehlung Reifen: </label><p id="RFEMPFEHL_ID" name="" class="InputNormal"><b>keine Fehler</b></p></div></div><div id="EmpfehlungFelgen"><div><label for="FGEMPFEHL_ID" class="Label">Empfehlung Felgen: </label><p id="FGEMPFEHL_ID" name="" class="InputNormal"><b>keine Fehler</b></p></div></div><div id="EmpfehlungPrüfergebnis"><div><label for="EMPFEHL_ID" class="Label">Empfehlung: </label><p id="EMPFEHL_ID" name="" class="InputNormal"><b>keine Fehler</b></p></div></div></div></div></div></div></div></div><div id="filter"></div>
             <div id="box" class="box">
                <div id="boximage">
                </div>
                <p id="boxtitle_box" class="boxtitle"></p>
            </div><div id="fotoGallery"><div id="BildContent"><div class="VLbild"><div class="imgLine"><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | VL&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76386&amp;FN=ShowPruefDoc"></div><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | VL&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76387&amp;FN=ShowPruefDoc"></div><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | VL&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76388&amp;FN=ShowPruefDoc"></div><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | VL&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76385&amp;FN=ShowPruefDoc"></div></div><div class="RadPosition"><label for="RadPos" class="Label">Position: </label><p id="RadPos" name="" class="InputNormal"><b>VL</b></p></div></div><div class="VRbild"><div class="imgLine"><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | VR&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76390&amp;FN=ShowPruefDoc"></div><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | VR&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76389&amp;FN=ShowPruefDoc"></div></div><div class="RadPosition"><label for="RadPos" class="Label">Position: </label><p id="RadPos" name="" class="InputNormal"><b>VR</b></p></div></div><div class="HLbild"><div class="imgLine"><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | HL&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76392&amp;FN=ShowPruefDoc"></div><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | HL&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76391&amp;FN=ShowPruefDoc"></div></div><div class="RadPosition"><label for="RadPos" class="Label">Position: </label><p id="RadPos" name="" class="InputNormal"><b>HL</b></p></div></div><div class="HRbild"><div class="imgLine"><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | HR&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76394&amp;FN=ShowPruefDoc"></div><div class="imgBox"><img id="myImg" onclick="openbox(&quot;9718476 | HR&quot;, &quot;box&quot;, this )" src="./index.php?m=wheelphoto&amp;a=show&amp;LGFOTO_ID=76393&amp;FN=ShowPruefDoc"></div></div><div class="RadPosition"><label for="RadPos" class="Label">Position: </label><p id="RadPos" name="" class="InputNormal"><b>HR</b></p></div></div></div></div>  </div>

  </div>                </div>
            </div>
      </div>

</div>';
}

// HTML-Daten extrahieren aus dem Sample HTML
function extractDataFromSampleHtml($field) {
    $html = getSampleHtml();
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    
    debugLog("=== SAMPLE HTML-ANALYSE FÜR FELD: $field ===");
    
    // Mapping der Feldnamen zu HTML-IDs
    $fieldMapping = [
        'fahrzeughalter' => 'WheelHALTERNAME',
        'kennzeichen' => 'WheelKENNZEICHEN',
        'fin' => 'WheelFAHRGESTNR',
        'eingangsnummer' => 'WheelLGS_ID',
        'ladestelle' => 'wheelsRUECK.LADESTELLE',
        'bemerkung' => 'KDBEMERK',
        'ruecklieferungsdatum' => 'WheelRUECKLIEFERTERMIN',
        'rueckgabe_bemerkung' => 'WheelRUECKAKTBEMERKUNG'
    ];
    
    $htmlId = $fieldMapping[$field] ?? null;
    if (!$htmlId) {
        throw new Exception("Unbekanntes Feld: $field");
    }
    
    debugLog("Suche nach Element mit ID: $htmlId");
    
    // Suche nach dem Element mit der entsprechenden ID
    $element = $xpath->query("//*[@id='$htmlId']")->item(0);
    
    if (!$element) {
        debugLog("Element mit ID '$htmlId' nicht gefunden für Feld '$field'");
        return '';
    }
    
    // Extrahiere den Textinhalt
    $value = trim($element->textContent);
    
    // Für Bemerkung-Felder: Suche nach textarea
    if ($field === 'bemerkung') {
        $textarea = $xpath->query("//textarea[@name='KDBEMERK']")->item(0);
        if ($textarea) {
            $value = trim($textarea->textContent);
            debugLog("Bemerkung aus textarea extrahiert: '$value'");
        }
    }
    
    // Für Ladestelle: Suche nach dem spezifischen Element
    if ($field === 'ladestelle') {
        $ladestelleElement = $xpath->query("//*[@id='wheelsRUECK.LADESTELLE']")->item(0);
        if ($ladestelleElement) {
            $value = trim($ladestelleElement->textContent);
            debugLog("Ladestelle extrahiert: '$value'");
        }
    }
    
    // Für Rücklieferungsdatum: Suche nach dem spezifischen Element
    if ($field === 'ruecklieferungsdatum') {
        $rueckElement = $xpath->query("//*[@id='WheelRUECKLIEFERTERMIN']")->item(0);
        if ($rueckElement) {
            $value = trim($rueckElement->textContent);
            debugLog("Rücklieferungsdatum extrahiert: '$value'");
        }
    }
    
    // Für Rückgabe Bemerkung: Suche nach dem spezifischen Element
    if ($field === 'rueckgabe_bemerkung') {
        $rueckBemerkungElement = $xpath->query("//*[@id='WheelRUECKAKTBEMERKUNG']")->item(0);
        if ($rueckBemerkungElement) {
            $value = trim($rueckBemerkungElement->textContent);
            debugLog("Rückgabe Bemerkung extrahiert: '$value'");
        }
    }
    
    debugLog("Feld '$field' (ID: $htmlId) extrahiert: '$value'");
    
    // Wenn Wert leer ist, suche nach <b> Tags innerhalb des Elements
    if (empty($value)) {
        $boldElement = $xpath->query(".//b", $element)->item(0);
        if ($boldElement) {
            $value = trim($boldElement->textContent);
            debugLog("Wert aus <b> Tag extrahiert: '$value'");
        }
    }
    
    debugLog("=== ENDE SAMPLE HTML-ANALYSE FÜR FELD: $field ===");
    return $value;
}

// Hauptverarbeitung
try {
    debugLog("=== SAMPLE RESY API Request Started ===");
    
    // JSON-Input lesen
    $rawInput = file_get_contents('php://input');
    debugLog("Raw Input Length: " . strlen($rawInput));
    
    if (empty($rawInput)) {
        throw new Exception('Keine Eingabedaten empfangen');
    }
    
    $input = json_decode($rawInput, true);
    
    if (!$input) {
        $error = json_last_error_msg();
        debugLog("JSON Decode Error: " . $error);
        throw new Exception('Keine gültigen JSON-Daten empfangen: ' . $error);
    }
    
    $action = $input['action'] ?? '';
    debugLog("Empfangene Aktion: $action");
    
    switch ($action) {
        case 'extract_field':
            $field = $input['field'] ?? null;
            debugLog("Extract field from sample HTML: $field");
            
            if (!$field) {
                throw new Exception('Feld-Name fehlt');
            }
            
            try {
                $value = extractDataFromSampleHtml($field);
                
                $result = [
                    'success' => true,
                    'value' => $value,
                    'field' => $field,
                    'message' => "Feld '$field' erfolgreich aus Sample HTML extrahiert"
                ];
                
                echo json_encode($result);
                
            } catch (Exception $e) {
                debugLog("Feld-Extraktion fehlgeschlagen: " . $e->getMessage());
                $result = [
                    'success' => false,
                    'error' => $e->getMessage(),
                    'field' => $field
                ];
                echo json_encode($result);
            }
            break;
            
        default:
            throw new Exception("Unbekannte Aktion: $action");
    }
    
} catch (Exception $e) {
    debugLog("API-Fehler: " . $e->getMessage());
    debugLog("Stack Trace: " . $e->getTraceAsString());
    
    // Sicherstellen, dass nur JSON ausgegeben wird
    http_response_code(500);
    $result = [
        'success' => false,
        'error' => $e->getMessage(),
        'debug' => [
            'file' => $e->getFile(),
            'line' => $e->getLine(),
            'timestamp' => date('Y-m-d H:i:s')
        ]
    ];
    echo json_encode($result);
}

debugLog("=== SAMPLE RESY API Request Ended ===");
?>
