<?php
/**
 * Logout - Benutzerabmeldung
 */
session_start();
require_once 'config.php';

try {
    // Session zerstören
    session_unset();
    session_destroy();
    
    // Optional: Token in Datenbank invalidieren
    if (isset($_SESSION['user_token'])) {
        $token = $_SESSION['user_token'];
        $stmt = $pdo->prepare("UPDATE users SET auth_token = NULL, token_expires_at = NOW() WHERE auth_token = ?");
        $stmt->execute([$token]);
    }
    
    // Redirect zu Login-Seite
    header('Location: ../login.php');
    exit;
    
} catch (Exception $e) {
    // Auch bei Fehler zur Login-Seite weiterleiten
    header('Location: ../login.php');
    exit;
}
?>

