<?php
/**
 * Passwort ändern
 */

session_start();

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['current_password']) || !isset($input['new_password'])) {
        throw new Exception('Aktuelles Passwort und neues Passwort sind erforderlich');
    }
    
    $currentPassword = $input['current_password'];
    $newPassword = $input['new_password'];
    
    // User laden
    $stmt = $conn->prepare("SELECT id, password_hash FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
    
    if (!$user) {
        throw new Exception('Benutzer nicht gefunden');
    }
    
    // Aktuelles Passwort überprüfen
    if (!password_verify($currentPassword, $user['password_hash'])) {
        throw new Exception('Aktuelles Passwort ist falsch');
    }
    
    // Neues Passwort hashen
    $newPasswordHash = password_hash($newPassword, PASSWORD_DEFAULT);
    
    // Passwort aktualisieren
    $stmt = $conn->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
    $result = $stmt->execute([$newPasswordHash, $user['id']]);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => 'Passwort erfolgreich geändert'
        ]);
    } else {
        throw new Exception('Fehler beim Ändern des Passworts');
    }
    
} catch (\Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

