<?php
/**
 * Analysiere die HTML-Antwort der neuen URL-Struktur
 */

$tempDir = sys_get_temp_dir();
$htmlFile = $tempDir . '/resy_fallback_9877038.html';

echo "=== ANALYSE DER HTML-ANTWORT MIT NEUER URL-STRUKTUR ===\n";
echo "Datei: " . basename($htmlFile) . "\n\n";

if (!file_exists($htmlFile)) {
    echo "❌ Datei nicht gefunden\n";
    exit;
}

$content = file_get_contents($htmlFile);

// Dekomprimiere gzip falls nötig
if (substr($content, 0, 2) === "\x1f\x8b") {
    $content = gzdecode($content);
    echo "✅ Gzip-Daten dekodiert\n";
}

echo "Inhalt-Länge: " . strlen($content) . " Zeichen\n\n";

// Extrahiere wichtige Informationen
echo "=== WICHTIGE INFORMATIONEN ===\n";

// Titel
if (preg_match('/<title[^>]*>(.*?)<\/title>/i', $content, $matches)) {
    echo "Titel: " . trim($matches[1]) . "\n";
}

// Suche nach spezifischen RESY-Elementen
echo "\n=== RESY-SPEZIFISCHE ELEMENTE ===\n";
$resyElements = [
    'Wheelset' => 'Wheelset',
    'LGS_ID' => 'LGS_ID',
    'WheelHALTERNAME' => 'WheelHALTERNAME',
    'WheelKENNZEICHEN' => 'WheelKENNZEICHEN',
    'WheelFAHRGESTNR' => 'WheelFAHRGESTNR',
    'WheelsetView' => 'WheelsetView',
    'WheelsetSearch' => 'WheelsetSearch',
    'WheelsetResult' => 'WheelsetResult',
    'Anmeldename' => 'Anmeldename',
    'Kennwort' => 'Kennwort',
    'login' => 'login',
    'search' => 'search',
    'suchen' => 'suchen',
    'error' => 'error',
    'fehler' => 'fehler',
    'not found' => 'not found',
    'nicht gefunden' => 'nicht gefunden'
];

foreach ($resyElements as $element => $label) {
    $count = substr_count($content, $element);
    if ($count > 0) {
        echo "$label: $count Vorkommen\n";
    }
}

// Suche nach Links mit LGS_ID
echo "\n=== LINKS MIT LGS_ID ===\n";
if (preg_match_all('/href=["\'][^"\']*LGS_ID[^"\']*["\']/', $content, $matches)) {
    echo "LGS_ID Links gefunden: " . count($matches[0]) . "\n";
    foreach ($matches[0] as $link) {
        echo "  - $link\n";
    }
} else {
    echo "Keine LGS_ID Links gefunden\n";
}

// Suche nach Formularen
echo "\n=== FORMULARE ===\n";
if (preg_match_all('/<form[^>]*>(.*?)<\/form>/is', $content, $matches)) {
    echo "Formulare gefunden: " . count($matches[0]) . "\n";
    
    foreach ($matches[0] as $i => $form) {
        echo "Formular " . ($i + 1) . ":\n";
        
        // Action
        if (preg_match('/action=["\']([^"\']*)["\']/', $form, $actionMatch)) {
            echo "  Action: " . $actionMatch[1] . "\n";
        }
        
        // Method
        if (preg_match('/method=["\']([^"\']*)["\']/', $form, $methodMatch)) {
            echo "  Method: " . $methodMatch[1] . "\n";
        }
        
        // Input-Felder
        if (preg_match_all('/<input[^>]*>/i', $form, $inputs)) {
            echo "  Input-Felder: " . count($inputs[0]) . "\n";
            foreach ($inputs[0] as $input) {
                if (preg_match('/name=["\']([^"\']*)["\']/', $input, $nameMatch)) {
                    $name = $nameMatch[1];
                    $type = 'text';
                    if (preg_match('/type=["\']([^"\']*)["\']/', $input, $typeMatch)) {
                        $type = $typeMatch[1];
                    }
                    echo "    - $name ($type)\n";
                }
            }
        }
    }
}

// Zeige einen Ausschnitt des HTML-Inhalts
echo "\n=== HTML-AUSSCHNITT (erste 2000 Zeichen) ===\n";
echo substr($content, 0, 2000) . "\n";

echo "\n=== ANALYSE ABGESCHLOSSEN ===\n";
?>
