<?php
/**
 * Kundenprofil Modal für Admin Dashboard
 */
?>
<!-- Customer Profile Modal -->
<div id="customer-profile-modal" class="modal" style="display: none;">
    <div class="modal-content" style="max-width: 900px;">
        <div class="modal-header">
            <h3><i class="fas fa-user"></i> Kundenprofil</h3>
            <button class="modal-close" onclick="closeCustomerProfileModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="customer-profile-content">
            <div style="text-align: center; padding: 3rem;">
                <i class="fas fa-spinner fa-spin" style="font-size: 3rem; color: #6c757d;"></i>
                <p style="margin-top: 1rem; color: #6c757d;">Lade Kundendaten...</p>
            </div>
        </div>
    </div>
</div>

<style>
    .customer-profile-section {
        margin-bottom: 2rem;
    }
    
    .customer-profile-section h4 {
        margin: 0 0 1rem 0;
        color: #003057;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .customer-info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 1rem;
    }
    
    .customer-info-item {
        padding: 1rem;
        background: #f8f9fa;
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }
    
    .customer-info-label {
        font-size: 0.85rem;
        color: #6c757d;
        margin-bottom: 0.5rem;
    }
    
    .customer-info-value {
        font-weight: 600;
        color: #495057;
    }
    
    .activity-timeline {
        position: relative;
        padding-left: 2rem;
    }
    
    .activity-timeline::before {
        content: '';
        position: absolute;
        left: 0.5rem;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e9ecef;
    }
    
    .activity-item {
        position: relative;
        padding: 1rem;
        margin-bottom: 1rem;
        background: #fff;
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }
    
    .activity-item::before {
        content: '';
        position: absolute;
        left: -1.75rem;
        top: 1.5rem;
        width: 12px;
        height: 12px;
        background: #003057;
        border-radius: 50%;
        border: 2px solid #fff;
    }
    
    .activity-icon {
        display: inline-block;
        width: 30px;
        height: 30px;
        background: linear-gradient(135deg, #003057 0%, #0056b3 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
    }
    
    .vehicle-card {
        padding: 1rem;
        background: #fff;
        border-radius: 8px;
        border: 2px solid #e9ecef;
        margin-bottom: 1rem;
    }
    
    .vehicle-card .vehicle-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 0.5rem;
    }
    
    .vehicle-card .vehicle-license {
        font-weight: 600;
        font-size: 1.1rem;
        color: #003057;
    }
    
    .vehicle-card .vehicle-details {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 0.5rem;
        font-size: 0.9rem;
        color: #6c757d;
    }
    
    .appointment-card {
        padding: 1rem;
        background: #fff;
        border-radius: 8px;
        border: 2px solid #e9ecef;
        margin-bottom: 1rem;
    }
    
    .appointment-card .appointment-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 0.5rem;
    }
    
    .appointment-status-badge {
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
    }
    
    .appointment-status-badge.booked {
        background: #28a745;
        color: #fff;
    }
    
    .appointment-status-badge.pending {
        background: #ffc107;
        color: #212529;
    }
    
    .appointment-status-badge.cancelled {
        background: #dc3545;
        color: #fff;
    }
</style>

<script>
    async function showCustomerProfile(userId) {
        const modal = document.getElementById('customer-profile-modal');
        const content = document.getElementById('customer-profile-content');
        
        if (!modal || !content) {
            console.error('Modal nicht gefunden');
            return;
        }
        
        modal.style.display = 'flex';
        content.innerHTML = `
            <div style="text-align: center; padding: 3rem;">
                <i class="fas fa-spinner fa-spin" style="font-size: 3rem; color: #6c757d;"></i>
                <p style="margin-top: 1rem; color: #6c757d;">Lade Kundendaten...</p>
            </div>
        `;
        
        try {
            const response = await fetch('../api/get_customer_profile.php?user_id=' + userId);
            const data = await response.json();
            
            if (data.success) {
                content.innerHTML = generateCustomerProfileHTML(data);
            } else {
                content.innerHTML = `
                    <div style="text-align: center; padding: 3rem;">
                        <i class="fas fa-exclamation-triangle" style="font-size: 3rem; color: #dc3545;"></i>
                        <p style="margin-top: 1rem; color: #dc3545;">Fehler beim Laden der Daten</p>
                    </div>
                `;
            }
        } catch (error) {
            content.innerHTML = `
                <div style="text-align: center; padding: 3rem;">
                    <i class="fas fa-exclamation-triangle" style="font-size: 3rem; color: #dc3545;"></i>
                    <p style="margin-top: 1rem; color: #dc3545;">Verbindungsfehler</p>
                </div>
            `;
        }
    }
    
    function generateCustomerProfileHTML(data) {
        const user = data.user;
        const vehicles = data.vehicles || [];
        const appointments = data.appointments || [];
        const activities = data.activities || [];
        const stats = data.stats || {};
        
        return `
            <div class="customer-profile-section">
                <div class="customer-info-grid">
                    <div class="customer-info-item">
                        <div class="customer-info-label">Name</div>
                        <div class="customer-info-value">${user.first_name} ${user.last_name}</div>
                    </div>
                    <div class="customer-info-item">
                        <div class="customer-info-label">E-Mail</div>
                        <div class="customer-info-value">${user.email}</div>
                    </div>
                    <div class="customer-info-item">
                        <div class="customer-info-label">Telefon</div>
                        <div class="customer-info-value">${user.phone_number || '-'}</div>
                    </div>
                    <div class="customer-info-item">
                        <div class="customer-info-label">Status</div>
                        <div class="customer-info-value">
                            ${stats.verification_status === 'approved' ? '✓ Verifiziert' : 
                              stats.verification_status === 'pending' ? '🔄 Pending' : 
                              stats.verification_status === 'rejected' ? '✗ Abgelehnt' : '-'}
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="customer-profile-section">
                <h4><i class="fas fa-car"></i> Fahrzeuge (${stats.total_vehicles || 0})</h4>
                ${vehicles.length > 0 ? vehicles.map(v => `
                    <div class="vehicle-card">
                        <div class="vehicle-header">
                            <div class="vehicle-license">${v.license_plate}</div>
                            ${v.is_default ? '<span style="color: #ffc107;">★ Standard</span>' : ''}
                        </div>
                        <div class="vehicle-details">
                            ${v.vehicle_brand ? `<div><strong>Marke:</strong> ${v.vehicle_brand}</div>` : ''}
                            ${v.vehicle_model ? `<div><strong>Modell:</strong> ${v.vehicle_model}</div>` : ''}
                            ${v.vehicle_year ? `<div><strong>Baujahr:</strong> ${v.vehicle_year}</div>` : ''}
                            ${v.notes ? `<div><strong>Notizen:</strong> ${v.notes}</div>` : ''}
                        </div>
                    </div>
                `).join('') : '<p style="color: #6c757d;">Keine Fahrzeuge vorhanden</p>'}
            </div>
            
            <div class="customer-profile-section">
                <h4><i class="fas fa-calendar-alt"></i> Termine (${stats.total_appointments || 0})</h4>
                ${appointments.length > 0 ? appointments.map(apt => {
                    const date = new Date(apt.event_date).toLocaleDateString('de-DE');
                    const time = apt.event_time ? new Date('1970-01-01T' + apt.event_time).toLocaleTimeString('de-DE', { hour: '2-digit', minute: '2-digit' }) : '';
                    return `
                        <div class="appointment-card">
                            <div class="appointment-header">
                                <div>
                                    <strong>${apt.event_name || 'Unbekannt'}</strong>
                                    <br><small>${date} ${time}</small>
                                </div>
                                <span class="appointment-status-badge ${apt.status}">${apt.status}</span>
                            </div>
                            ${apt.autohaus_name ? `<div><i class="fas fa-building"></i> ${apt.autohaus_name}</div>` : ''}
                        </div>
                    `;
                }).join('') : '<p style="color: #6c757d;">Keine Termine vorhanden</p>'}
            </div>
            
            <div class="customer-profile-section">
                <h4><i class="fas fa-history"></i> Aktivitäten (${stats.total_activities || 0})</h4>
                <div class="activity-timeline">
                    ${activities.length > 0 ? activities.map(activity => `
                        <div class="activity-item">
                            <div style="display: flex; align-items: start;">
                                <div class="activity-icon">
                                    <i class="fas fa-circle" style="font-size: 0.5rem; color: #fff;"></i>
                                </div>
                                <div style="flex: 1;">
                                    <div style="font-weight: 600; margin-bottom: 0.25rem;">${activity.description}</div>
                                    <small style="color: #6c757d;">${new Date(activity.created_at).toLocaleString('de-DE')}</small>
                                </div>
                            </div>
                        </div>
                    `).join('') : '<p style="color: #6c757d;">Keine Aktivitäten vorhanden</p>'}
                </div>
            </div>
        `;
    }
    
    function closeCustomerProfileModal() {
        document.getElementById('customer-profile-modal').style.display = 'none';
    }
    
    // Close modal when clicking outside
    document.getElementById('customer-profile-modal')?.addEventListener('click', function(e) {
        if (e.target === this) {
            closeCustomerProfileModal();
        }
    });
</script>

