<?php
/**
 * Test-Script um zu prüfen ob die Dokumenten-API funktioniert
 */

session_start();
require_once '../config/database.php';

// Simuliere Admin-Login für Test
$_SESSION['admin_logged_in'] = true;
$_SESSION['admin_user_id'] = 1;

echo "<h2>Test der Dokumenten-API</h2>";

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe ob verification_documents Tabelle existiert
    $stmt = $conn->query("SHOW TABLES LIKE 'verification_documents'");
    if ($stmt->rowCount() > 0) {
        echo "<p>✅ Tabelle verification_documents existiert</p>";
        
        // Prüfe Struktur
        $stmt = $conn->query("DESCRIBE verification_documents");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "<h3>Tabellenstruktur:</h3><ul>";
        foreach ($columns as $column) {
            echo "<li>{$column['Field']} - {$column['Type']}</li>";
        }
        echo "</ul>";
        
        // Prüfe ob Daten vorhanden sind
        $stmt = $conn->query("SELECT COUNT(*) as count FROM verification_documents");
        $count = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p>Anzahl Dokumente in der Datenbank: {$count['count']}</p>";
        
        if ($count['count'] > 0) {
            $stmt = $conn->query("SELECT * FROM verification_documents LIMIT 5");
            $docs = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo "<h3>Beispiel-Dokumente:</h3><ul>";
            foreach ($docs as $doc) {
                echo "<li>ID: {$doc['id']}, User: {$doc['user_id']}, Datei: {$doc['file_name']}, Status: {$doc['review_status']}</li>";
            }
            echo "</ul>";
        }
        
    } else {
        echo "<p>❌ Tabelle verification_documents existiert NICHT</p>";
    }
    
    // Teste API-Endpunkt
    echo "<h3>API-Test:</h3>";
    $test_user_id = 10;
    echo "<p>Teste API für User ID: $test_user_id</p>";
    
    // Simuliere GET-Request
    $_GET['user_id'] = $test_user_id;
    
    ob_start();
    include 'api/get_user_documents.php';
    $api_output = ob_get_clean();
    
    echo "<h4>API-Ausgabe:</h4>";
    echo "<pre>" . htmlspecialchars($api_output) . "</pre>";
    
} catch (Exception $e) {
    echo "<p>❌ Fehler: " . $e->getMessage() . "</p>";
}
?>
