<?php
/**
 * 🚀 QUICK ACTIONS SETUP
 * Setup database table for user-configurable quick actions
 */

require_once '../config/database_optimized.php';

try {
    $db = DatabaseOptimized::getInstance();
    $conn = $db->getConnection();
    
    // Create quick_actions table
    $sql = "
    CREATE TABLE IF NOT EXISTS quick_actions (
        id INT PRIMARY KEY AUTO_INCREMENT,
        title VARCHAR(100) NOT NULL,
        description VARCHAR(255),
        icon VARCHAR(50) NOT NULL DEFAULT 'fas fa-star',
        url VARCHAR(500) NOT NULL,
        target VARCHAR(10) DEFAULT '_self',
        background_color VARCHAR(7) DEFAULT '#007bff',
        text_color VARCHAR(7) DEFAULT '#ffffff',
        position_order INT DEFAULT 0,
        is_active TINYINT DEFAULT 1,
        user_id INT,
        autohaus_id INT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        
        INDEX idx_active_order (is_active, position_order),
        INDEX idx_user_autohaus (user_id, autohaus_id),
        
        FOREIGN KEY (user_id) REFERENCES admin_users(id) ON DELETE SET NULL,
        FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE SET NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ";
    
    $conn->exec($sql);
    
    // Insert default quick actions for existing users
    $default_actions = [
        [
            'title' => 'Neues Event',
            'description' => 'Erstelle ein neues Event',
            'icon' => 'fas fa-plus',
            'url' => 'events.php?action=create',
            'background_color' => '#28a745',
            'position_order' => 1
        ],
        [
            'title' => 'Termine verwalten',
            'description' => 'Verwalte alle Termine',
            'icon' => 'fas fa-calendar-check',
            'url' => 'appointments.php',
            'background_color' => '#007bff',
            'position_order' => 2
        ],
        [
            'title' => 'Einlagerungen',
            'description' => 'Verwalte Einlagerungen',
            'icon' => 'fas fa-warehouse',
            'url' => 'storage.php',
            'background_color' => '#fd7e14',
            'position_order' => 3
        ],
        [
            'title' => 'Frontend anzeigen',
            'description' => 'Öffne das Frontend',
            'icon' => 'fas fa-external-link-alt',
            'url' => '../index.php',
            'target' => '_blank',
            'background_color' => '#6f42c1',
            'position_order' => 4
        ]
    ];
    
    // Check if any quick actions exist
    $existing = $conn->query("SELECT COUNT(*) FROM quick_actions")->fetchColumn();
    
    if ($existing == 0) {
        $stmt = $conn->prepare("
            INSERT INTO quick_actions (title, description, icon, url, target, background_color, position_order) 
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        
        foreach ($default_actions as $action) {
            $stmt->execute([
                $action['title'],
                $action['description'],
                $action['icon'],
                $action['url'],
                $action['target'] ?? '_self',
                $action['background_color'],
                $action['position_order']
            ]);
        }
        
        echo "✅ Quick Actions Tabelle erstellt und mit Standard-Aktionen gefüllt!\n";
    } else {
        echo "ℹ️ Quick Actions Tabelle existiert bereits mit {$existing} Einträgen.\n";
    }
    
} catch (Exception $e) {
    echo "❌ Fehler beim Setup: " . $e->getMessage() . "\n";
}
?>