<?php
/**
 * Einheitliche Sidebar-Komponente für alle Admin-Seiten
 * Basierend auf der Performance-Dashboard Sidebar
 */

// Aktuelle Seite ermitteln
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$current_user_name = $current_user_name ?? 'Administrator';
$current_user_role = $current_user_role ?? 'admin';
?>

<!-- 🧭 Smart Sidebar -->
<aside class="smart-sidebar" id="smartSidebar">
    <!-- Sidebar Header -->
    <div class="sidebar-header">
        <div class="logo-section">
            <div class="logo-icon">
                <i class="fas fa-rocket"></i>
            </div>
            <div class="logo-text">
                <h1>Boxenstop</h1>
                <span>Admin Panel</span>
            </div>
        </div>
        
        <!-- 🎛️ Theme Toggle -->
        <form method="POST" style="display: inline;">
            <button type="submit" name="toggle_theme" class="theme-toggle" title="Theme wechseln">
                <i class="fas fa-<?php echo $current_theme === 'light' ? 'moon' : 'sun'; ?>"></i>
            </button>
        </form>
    </div>

    <!-- Smart Navigation -->
    <nav class="smart-nav">
        <a href="index.php" class="nav-item <?php echo $current_page === 'index' ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt"></i>
            <span>Dashboard</span>
        </a>
        
        <a href="admin_dashboard.php" class="nav-item <?php echo $current_page === 'admin_dashboard' ? 'active' : ''; ?>">
            <i class="fas fa-users"></i>
            <span>Kunden</span>
        </a>
        
        <a href="events.php" class="nav-item <?php echo $current_page === 'events' ? 'active' : ''; ?>">
            <i class="fas fa-calendar-alt"></i>
            <span>Events</span>
        </a>
        
        <a href="appointments.php" class="nav-item <?php echo $current_page === 'appointments' ? 'active' : ''; ?>">
            <i class="fas fa-clock"></i>
            <span>Termine</span>
        </a>
        
        <a href="storage.php" class="nav-item <?php echo $current_page === 'storage' ? 'active' : ''; ?>">
            <i class="fas fa-warehouse"></i>
            <span>Lagerverwaltung</span>
        </a>
        
        <a href="users.php" class="nav-item <?php echo $current_page === 'users' ? 'active' : ''; ?>">
            <i class="fas fa-user-shield"></i>
            <span>Mitarbeiter</span>
        </a>
        
        <a href="settings.php" class="nav-item <?php echo $current_page === 'settings' ? 'active' : ''; ?>">
            <i class="fas fa-cog"></i>
            <span>Einstellungen</span>
        </a>
        
        <a href="api_manager.php" class="nav-item <?php echo $current_page === 'api_manager' ? 'active' : ''; ?>">
            <i class="fas fa-key"></i>
            <span>API Manager</span>
        </a>
    </nav>

    <!-- Sidebar Footer -->
    <div class="sidebar-footer">
        <!-- User Menu -->
        <div class="user-menu-container">
            <button class="user-menu-btn" id="user-menu-btn">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-info">
                    <span class="user-name"><?php echo htmlspecialchars($current_user_name); ?></span>
                    <span class="user-role">Administrator</span>
                </div>
                <i class="fas fa-chevron-down user-chevron"></i>
            </button>
            
            <div class="user-dropdown" id="user-dropdown">
                <a href="profile.php" class="user-dropdown-item">
                    <i class="fas fa-user"></i>
                    <span>Mein Profil</span>
                </a>
                <a href="settings.php" class="user-dropdown-item">
                    <i class="fas fa-cog"></i>
                    <span>Einstellungen</span>
                </a>
                <a href="users.php" class="user-dropdown-item">
                    <i class="fas fa-users"></i>
                    <span>Benutzer</span>
                </a>
                <div class="user-dropdown-divider"></div>
                <a href="logout.php" class="user-dropdown-item logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Abmelden</span>
                </a>
            </div>
        </div>
    </div>
</aside>
