<?php
/**
 * Überprüfe Tabellenstruktur
 */

session_start();
require_once '../config/database.php';

// Simuliere Admin-Login
$_SESSION['admin_logged_in'] = true;
$_SESSION['admin_user_id'] = 1;

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe Tabellenstruktur
    $stmt = $conn->query("DESCRIBE verification_documents");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Tabellenstruktur verification_documents:</h2>";
    echo "<table border='1'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td>{$column['Field']}</td>";
        echo "<td>{$column['Type']}</td>";
        echo "<td>{$column['Null']}</td>";
        echo "<td>{$column['Key']}</td>";
        echo "<td>{$column['Default']}</td>";
        echo "<td>{$column['Extra']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Prüfe ob review_status Spalte existiert
    $has_review_status = false;
    foreach ($columns as $column) {
        if ($column['Field'] === 'review_status') {
            $has_review_status = true;
            break;
        }
    }
    
    if (!$has_review_status) {
        echo "<h3>❌ review_status Spalte fehlt! Füge sie hinzu...</h3>";
        
        // Füge fehlende Spalten hinzu
        $alter_queries = [
            "ALTER TABLE verification_documents ADD COLUMN review_status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending'",
            "ALTER TABLE verification_documents ADD COLUMN reviewed_by INT NULL",
            "ALTER TABLE verification_documents ADD COLUMN reviewed_at TIMESTAMP NULL",
            "ALTER TABLE verification_documents ADD COLUMN review_notes TEXT NULL",
            "ALTER TABLE verification_documents ADD COLUMN rejection_reason TEXT NULL"
        ];
        
        foreach ($alter_queries as $query) {
            try {
                $conn->exec($query);
                echo "<p>✅ Query erfolgreich: " . substr($query, 0, 50) . "...</p>";
            } catch (Exception $e) {
                echo "<p>❌ Fehler bei Query: " . $e->getMessage() . "</p>";
            }
        }
    } else {
        echo "<h3>✅ review_status Spalte existiert!</h3>";
    }
    
} catch (Exception $e) {
    echo "<p>❌ Fehler: " . $e->getMessage() . "</p>";
}
?>
