<?php
session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
  http_response_code(401);
  echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
  exit;
}

require_once __DIR__ . '/../../config/database.php';

try {
  $input = json_decode(file_get_contents('php://input'), true) ?? [];
  $password = (string)($input['password'] ?? '');
  if ($password === '') throw new Exception('Passwort erforderlich');

  $adminUserId = $_SESSION['admin_user_id'] ?? null;
  if (!$adminUserId) throw new Exception('Admin-Session unvollständig');

  $db = new Database();
  $conn = $db->getConnection();
  $stmt = $conn->prepare('SELECT password_hash FROM admin_users WHERE id = ? AND is_active = 1');
  $stmt->execute([$adminUserId]);
  $row = $stmt->fetch(PDO::FETCH_ASSOC);
  if (!$row) throw new Exception('Admin-Benutzer nicht gefunden/aktiv');

  if (!password_verify($password, $row['password_hash'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Falsches Passwort']);
    exit;
  }

  $_SESSION['last_reauth_time'] = time();
  echo json_encode(['success' => true]);
} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}


