<?php
session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();

    // Letzte 100 Requests
    $stmt = $conn->query("SELECT u.id, u.api_key_id, k.name as api_key_name, u.endpoint, u.http_method, u.status_code, u.request_ts, u.ip FROM api_key_usage u LEFT JOIN api_keys k ON u.api_key_id = k.id ORDER BY u.request_ts DESC LIMIT 100");
    $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Summary Stats
    $stmt = $conn->query("
        SELECT 
            COUNT(*) as total_requests,
            SUM(CASE WHEN status_code >= 200 AND status_code < 300 THEN 1 ELSE 0 END) as success_requests,
            SUM(CASE WHEN status_code >= 400 AND status_code < 500 THEN 1 ELSE 0 END) as client_errors,
            SUM(CASE WHEN status_code >= 500 THEN 1 ELSE 0 END) as server_errors,
            SUM(bytes_in + bytes_out) as total_bytes
        FROM api_key_usage 
        WHERE request_ts > (NOW() - INTERVAL 1 DAY)
    ");
    $summary = $stmt->fetch(PDO::FETCH_ASSOC) ?: ['total_requests' => 0, 'success_requests' => 0, 'client_errors' => 0, 'server_errors' => 0, 'total_bytes' => 0];

    // Top-Endpoints mit Fehlerzählung
    $stmt = $conn->query("SELECT endpoint, COUNT(*) as count, SUM(CASE WHEN status_code >= 400 THEN 1 ELSE 0 END) as errors FROM api_key_usage WHERE request_ts > (NOW() - INTERVAL 1 DAY) GROUP BY endpoint ORDER BY count DESC LIMIT 10");
    $topEndpoints = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['success' => true, 'logs' => $logs, 'summary' => $summary, 'top_endpoints' => $topEndpoints]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
