# Storage Scoring Fix

## Problem
```
Fatal error: Uncaught PDOException: SQLSTATE[42S22]: Column not found: 1054 Unknown column 'item_name' in 'field list'
```

## Ursache
Das intelligente Scoring-System versuchte, auf Spalten in der `storage` Tabelle zuzugreifen, die nicht existieren:
- `item_name` ❌ (existiert nicht)
- `item_type` ❌ (existiert nicht)

## Lösung
Die SQL-Abfrage wurde angepasst, um nur die tatsächlich vorhandenen Spalten der `storage` Tabelle zu verwenden:

### Vorher (fehlerhaft):
```sql
COUNT(DISTINCT item_name) as unique_items
```

### Nachher (korrekt):
```sql
COUNT(DISTINCT storage_number) as unique_storage_numbers,
COUNT(DISTINCT customer_name) as unique_customers,
COUNT(CASE WHEN status = 'stored' THEN 1 END) as stored_items,
COUNT(CASE WHEN status = 'retrieved' THEN 1 END) as retrieved_items
```

## Verfügbare Spalten in der `storage` Tabelle:
- `id` - Primärschlüssel
- `storage_number` - Eindeutige Lagerplatznummer
- `customer_name` - Kundename
- `license_plate` - Kennzeichen
- `phone` - Telefonnummer
- `storage_date` - Einlagerungsdatum
- `status` - Status ('stored' oder 'retrieved')
- `created_at` - Erstellungsdatum
- `updated_at` - Aktualisierungsdatum

## Verbesserte Scoring-Logik:
1. **Basis-Punkte**: 0.3 Punkte pro Lageraktivität (max. 15)
2. **Aktualitäts-Bonus**: 0.2 Punkte pro Aktivität in den letzten 30 Tagen (max. 5)
3. **Vielfalts-Bonus**: 0.05 Punkte pro einzigartigem Lagerplatz und Kunde (max. 3)

## Angezeigte Statistiken:
- Gesamte Aktivitäten (90 Tage)
- Aktuelle Aktivitäten (30 Tage)
- Einzigartige Lagerplätze
- Einzigartige Kunden
- Eingelagerte Artikel
- Abgeholte Artikel

**Das Storage-Scoring funktioniert jetzt korrekt mit den verfügbaren Daten! ✅**
