# Verifizierungssystem - Setup-Anleitung

## Fehler: Column not found: verification_status

Das Problem: Die `verification_status` Spalte existiert noch nicht in der Datenbank.

## Lösung

### Methode 1: Via phpMyAdmin (Empfohlen)

1. Öffne phpMyAdmin: `http://localhost/phpmyadmin`
2. Wähle Datenbank `boxxenstopp`
3. Gehe zu SQL Tab
4. Kopiere und führe aus:

```sql
-- Einfache Version - ohne IF EXISTS
ALTER TABLE users ADD COLUMN verification_status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending';
ALTER TABLE users ADD COLUMN verification_document VARCHAR(500) NULL;
ALTER TABLE users ADD COLUMN verification_reason TEXT NULL;
ALTER TABLE users ADD COLUMN verified_by INT NULL;
ALTER TABLE users ADD COLUMN verified_at DATETIME NULL;
CREATE INDEX idx_verification_status ON users(verification_status);
UPDATE users SET verification_status = 'approved' WHERE verification_status IS NULL;
```

### Methode 2: Via Kommandozeile

Öffne Command Prompt und führe aus:

```bash
cd C:\xampp\htdocs\boxenstop
C:\xampp\mysql\bin\mysql.exe -u Admin50 -pIkizler123! boxxenstopp < database\add_verification_fields.sql
```

### Methode 3: Via XAMPP Shell

1. Öffne XAMPP Control Panel
2. Klicke auf "Shell"
3. Führe aus:

```bash
cd C:\xampp\htdocs\boxenstop
mysql -u Admin50 -pIkizler123! boxxenstopp -e "ALTER TABLE users ADD COLUMN verification_status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending'"
mysql -u Admin50 -pIkizler123! boxxenstopp -e "ALTER TABLE users ADD COLUMN verification_document VARCHAR(500) NULL"
mysql -u Admin50 -pIkizler123! boxxenstopp -e "ALTER TABLE users ADD COLUMN verification_reason TEXT NULL"
mysql -u Admin50 -pIkizler123! boxxenstopp -e "ALTER TABLE users ADD COLUMN verified_by INT NULL"
mysql -u Admin50 -pIkizler123! boxxenstopp -e "ALTER TABLE users ADD COLUMN verified_at DATETIME NULL"
mysql -u Admin50 -pIkizler123! boxxenstopp -e "CREATE INDEX idx_verification_status ON users(verification_status)"
mysql -u Admin50 -pIkizler123! boxxenstopp -e "UPDATE users SET verification_status = 'approved' WHERE verification_status IS NULL"
```

## Nach der Installation

1. Teste die Installation:

   - Registriere einen neuen User
   - Prüfe ob `verification_status = 'pending'` ist
   - Lade ein Dokument hoch

2. Upload-Verzeichnis erstellen:

   ```bash
   mkdir uploads\verification_documents
   ```

3. Testen:
   - Als normaler User: Registrieren → Dokument hochladen
   - Als Admin: User in Dashboard sehen → Freischalten

## Nächste Schritte

Nach erfolgreicher Installation:

- Das System funktioniert automatisch
- Neue User starten mit `verification_status = 'pending'`
- Alte User sind automatisch auf `approved` gesetzt
