# 🔒 Security Phase 1 - Konkreter Implementierungsplan

## Übersicht

**Ziel**: Kritische Sicherheitslücken beheben (Phase 1 aus SECURITY_ANALYSIS.md)  
**Dauer**: ~2-3 Stunden  
**Priorität**: HOCH - Sofort implementieren

---

## 🎯 Phase 1 - Kritische Lücken (4 Fixes)

### ✅ Fix 1: Upload-Schutz via .htaccess

**Risiko**: HOCH  
**Zeit**: 10 min

#### Was wird gemacht:

- `.htaccess` in `uploads/` erstellen → Deny all
- Upload-Dateien nur via Proxy-Script (`view_document.php`) ausliefern
- Dateinamen sanitizing in Upload-Handlern prüfen

#### Betroffene Dateien:

```
uploads/.htaccess (NEU ERSTELLEN)
uploads/verification_documents/
uploads/profile/
uploads/offers/
uploads/tire_offers/
api/view_document.php (ZUM PRÜFEN)
api/upload_verification_document.php
api/update_profile.php
api/upload_autohaus_footer_image.php
```

#### Plan:

1. `.htaccess` erstellen → `Deny from all`
2. Alle Upload-Handler prüfen auf `basename()` und Pfad-Traversal-Schutz
3. Proxy-Scripts für sichere Auslieferung erweitern

---

### ✅ Fix 2: SQL-Injection beheben

**Risiko**: HOCH  
**Zeit**: 30 min

#### Was wird gemacht:

- Prüfen aller Files auf `$conn->exec()` mit User-Input
- Umstellen auf Prepared Statements
- Besonders Setup-Skripte und Tools überprüfen

#### Betroffene Dateien:

```bash
# Setup-Skripte
setup/create_image_cache_table.php
setup/create_resy_cache_tables.php
setup/create_tire_suggestions_table.php
apply_database_indexes.php
apply_database_updates.php

# Tools
tools/generate_api_key.php
tools/test_all_apis.php
```

#### Plan:

1. Alle Skripte durchsuchen nach `exec()` und direkten SQL-Strings
2. User-Input in SQL-Abfragen identifizieren
3. Auf Prepared Statements umstellen
4. Testen der geänderten Skripte

---

### ✅ Fix 3: Session-Regeneration bei Login

**Risiko**: MITTEL  
**Zeit**: 20 min

#### Was wird gemacht:

- `session_regenerate_id(true)` nach erfolgreicher Authentifizierung
- Verhindert Session Fixation Attacks

#### Betroffene Dateien:

```
api/login_user.php ← WICHTIG
api/register_user.php ← WICHTIG
api/apple_callback.php ← WICHTIG
admin/api/reauth.php ← Prüfen
```

#### Plan:

1. Nach erfolgreicher Auth → `session_regenerate_id(true)` einfügen
2. Bei Login, Register, Apple-Callback und Admin-Login
3. Testen ob Session nach Regeneration noch funktioniert

---

### ✅ Fix 4: CSRF-Token System

**Risiko**: HOCH  
**Zeit**: 60 min

#### Was wird gemacht:

- CSRF-Token Generator + Validator implementieren
- Token in allen Forms einfügen
- Backend-Validierung in allen POST-Endpunkten

#### Betroffene Dateien:

**Frontend Forms:**

```
index.php (Event-Booking)
booking.php (Booking-Form)
profile.php (Profil-Update)
admin_dashboard.php (Verifizierung)
admin/appointments.php (Termin-Updates)
admin/events.php (Event-Updates)
admin/users.php (Benutzer-Updates)
admin/settings.php (Einstellungen)
```

**Backend APIs:**

```
api/appointments.php (POST)
api/update_profile.php
api/admin_approve_user.php
api/admin_reject_user.php
api/link_user_to_admin.php
api/cancel_appointment.php
api/add_vehicle.php
api/update_vehicle.php
admin/api/api_keys.php (POST, PUT, DELETE)
admin/api/reauth.php
```

#### Plan:

1. **Helper-Funktionen erstellen**: `includes/csrf.php`
   ```php
   function generate_csrf_token()
   function validate_csrf_token($token)
   ```
2. **Frontend: Token einfügen**
   - In allen `<form>`: `<input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">`
   - In JavaScript Fetch: Token im Header senden
3. **Backend: Validierung**
   - Jeder POST-Endpunkt prüft Token
   - Bei Fehler: 403 Forbidden
4. **Testen**: Alle Forms testen

---

## 📋 Implementierungs-Reihenfolge

### Schritt 1: Upload-Schutz (10 min)

```
1. uploads/.htaccess erstellen
2. Upload-Handler prüfen
3. Testen: Upload → Zugriff über direkte URL muss blockiert sein
```

### Schritt 2: SQL-Injection (30 min)

```
1. Setup-Skripte durchsuchen
2. User-Input identifizieren
3. Prepared Statements implementieren
4. Testen: Skripte ausführen
```

### Schritt 3: Session-Regeneration (20 min)

```
1. login_user.php anpassen
2. register_user.php anpassen
3. apple_callback.php anpassen
4. Testen: Login → Session-ID muss sich ändern
```

### Schritt 4: CSRF-Tokens (60 min)

```
1. includes/csrf.php erstellen
2. Frontend: Alle Forms anpassen
3. Backend: Alle POST-Endpunkte validieren
4. Testen: Alle Forms funktionieren
```

---

## ✅ Test-Checklist nach Implementierung

### Upload-Schutz

- [ ] Direkter Zugriff auf Upload-Datei → 403 Forbidden
- [ ] Proxy-Script → Datei wird angezeigt
- [ ] Upload funktioniert noch

### SQL-Injection-Schutz

- [ ] Setup-Skripte ausführen → Keine Fehler
- [ ] User-Input wird nicht direkt in SQL verwendet
- [ ] Prepared Statements überall verwendet

### Session-Regeneration

- [ ] Login → Neue Session-ID
- [ ] Register → Neue Session-ID
- [ ] Apple-Callback → Neue Session-ID
- [ ] Session funktioniert nach Login

### CSRF-Schutz

- [ ] Form-Submit ohne Token → 403 Error
- [ ] Form-Submit mit Token → Erfolg
- [ ] Alle Forms funktionieren

---

## 🎯 Gesamt-Dauer: ~2 Stunden

**Nach Abschluss**: Phase 1 ist komplett, alle kritischen Lücken sind behoben.
