# 🔍 RESY Datenauslese Integration

## Übersicht
Diese Integration ermöglicht es, automatisch Daten aus dem RESY-System zu extrahieren und in das Boxxenstopp-System zu importieren.

## ✨ Features

### 1. **Automatische Datenauslese**
- Startet automatisch beim Klick auf "Reifen prüfen"
- Schritt-für-Schritt Extraktion aller Felder
- Benutzerbestätigung nach jedem Feld

### 2. **Professionelles Design**
- Moderne, minimalistische Benutzeroberfläche
- Icons für bessere Übersichtlichkeit
- Responsive Design für alle Bildschirmgrößen
- Hover-Effekte und Animationen

### 3. **Extrahierte Felder**
- 👤 **Fahrzeughalter**
- 🚗 **Kennzeichen**
- 📊 **FIN**
- 🔢 **Eingangsnummer**
- 🏭 **Ladestelle**
- 📝 **Bemerkung**
- 📅 **Rücklieferungsdatum**
- ↩️ **Rückgabe Bemerkung**

## 🚀 Verwendung

### Im Admin-Bereich:
1. Gehe zu einem Termin
2. Klicke auf "Reifen prüfen"
3. Die RESY-Datenauslese startet automatisch
4. Bestätige jedes Feld mit "OK"
5. Daten werden automatisch ausgefüllt

### Zum Testen:
1. Öffne `test_resy_extraction.html`
2. Ändere die LGS_ID nach Belieben
3. Klicke "Test starten"
4. Beobachte jeden Schritt in Echtzeit

## 🔧 Technische Details

### API-Endpunkte:
- `POST /api/resy_data_extraction.php`
  - `action: 'login'` - Anmeldung bei RESY
  - `action: 'navigate_to_search'` - Navigation zur Suchseite
  - `action: 'search_lgs_id'` - Suche nach LGS_ID
  - `action: 'navigate_to_detail'` - Navigation zur Detailseite
  - `action: 'extract_field'` - Extraktion einzelner Felder

### Datenbank-Integration:
- Verwendet Autohaus-Tabelle für RESY-Credentials
- `resy_username` und `resy_password` aus der Datenbank
- Automatische Autohaus-Zuordnung basierend auf Benutzer

### Sicherheit:
- Session-Management für RESY-Login
- Fehlerbehandlung auf allen Ebenen
- Logging aller Operationen in `logs/resy_extraction.log`

## 📋 Ablauf der Datenauslese

1. **Login** 🔐
   - Lädt RESY-Login-Seite
   - Extrahiert Credentials aus Datenbank
   - Führt Login durch

2. **Navigation** 🧭
   - Navigiert zu "Sätze/Rücklieferungen bestellen"
   - Lädt Suchformular

3. **Suche** 🔍
   - Fügt LGS_ID in Suchfeld ein
   - Startet Suche
   - Findet entsprechende Einlagerung

4. **Detailseite** 📄
   - Klickt auf gefundene Einlagerungsnummer
   - Lädt Detailseite mit allen Daten

5. **Extraktion** 📝
   - Extrahiert jedes Feld einzeln
   - Wartet auf Benutzerbestätigung
   - Füllt Formularfelder aus

## 🐛 Fehlerbehandlung

### Häufige Probleme:
- **"Keine LGS_ID gefunden"**: Termin hat keine Einlagerungsnummer
- **"Login fehlgeschlagen"**: RESY-Credentials falsch oder System nicht erreichbar
- **"JSON Parse Error"**: API gibt HTML statt JSON zurück (meist PHP-Fehler)

### Debugging:
- Alle Schritte werden in `logs/resy_extraction.log` protokolliert
- Test-Interface zeigt detaillierte Fehlermeldungen
- Browser-Konsole zeigt JavaScript-Fehler

## 🎯 Nächste Schritte

1. **Testen** mit verschiedenen LGS_IDs
2. **Anpassen** der Feld-Selektoren falls nötig
3. **Erweitern** um weitere Felder
4. **Optimieren** der Performance

## 📞 Support

Bei Problemen:
1. Prüfe die Log-Datei `logs/resy_extraction.log`
2. Teste mit `test_resy_extraction.html`
3. Überprüfe Browser-Konsole auf JavaScript-Fehler
4. Stelle sicher, dass RESY-Credentials korrekt sind

---
*Implementiert für Boxxenstopp - RESY Integration v1.0*
