# Registrierungs-Tracking System

## Übersicht

Das System trackt jetzt, wie und von wo Benutzer sich registrieren und anmelden.

## Neue Features

### 1. **Registrierungsquelle**

- `web` - Web-Browser Registrierung
- `ios` - iOS App
- `android` - Android App
- `apple_signin` - Apple Sign-In
- `unknown` - Unbekannt

### 2. **Device-Tracking**

- Windows, Mac, Linux
- iOS, Android
- Mobile Browser Detection

### 3. **IP-Tracking**

- Client-IP-Adresse wird gespeichert
- Proxy-Aware (X-Forwarded-For Support)

## Installation

### 1. Datenbank aktualisieren:

```sql
-- Führe das SQL-Skript aus:
mysql -u Admin50 -p boxxenstopp < database/add_registration_source_fields.sql
```

### 2. Oder manuell in phpMyAdmin:

```sql
ALTER TABLE users ADD COLUMN registration_source ENUM('web', 'ios', 'android', 'apple_signin', 'unknown') DEFAULT 'unknown';
ALTER TABLE users ADD COLUMN registration_device VARCHAR(100) NULL;
ALTER TABLE users ADD COLUMN registration_ip VARCHAR(45) NULL;
ALTER TABLE users ADD COLUMN last_login_source VARCHAR(100) NULL;
ALTER TABLE users ADD COLUMN last_login_device VARCHAR(100) NULL;
CREATE INDEX idx_registration_source ON users(registration_source);
```

## Verwendung

### Im Admin-Dashboard

Es gibt ein neues Widget: `user_registration_source_widget.php`

**Einbindung:**

```php
include 'widgets/user_registration_source_widget.php';
```

Das Widget zeigt:

- Verteilung der Registrierungsquellen
- Status-Verteilung (approved/pending/rejected) pro Quelle
- Gesamt-Statistik

### In der Benutzerliste

Beispiel SQL-Abfrage:

```php
$stmt = $conn->prepare("
    SELECT u.*, u.registration_source, u.registration_device,
           u.last_login_source, u.last_login_device
    FROM users u
");
$stmt->execute();
$users = $stmt->fetchAll();
```

### Icon-Mapping

Die Systeme verwenden folgende Icons:

- **Web**: 🌐 `fas fa-globe`
- **iOS**: 🍎 `fab fa-apple`
- **Android**: 🤖 `fab fa-android`
- **Apple Sign-In**: 🍎 `fab fa-apple`
- **Unknown**: ❓ `fas fa-question-circle`

### Farb-Mapping

- **web**: Blau (#007bff)
- **ios**: Schwarz (#000000)
- **android**: Grün (#3DDC84)
- **apple_signin**: Grau (#A8B1B9)
- **unknown**: Grau (#6c757d)

## API-Integration

### Registrierung mit Quelle:

```javascript
// JavaScript/Frontend
fetch("api/register_user.php", {
  method: "POST",
  headers: { "Content-Type": "application/json" },
  body: JSON.stringify({
    first_name: "Max",
    last_name: "Mustermann",
    email: "max@example.com",
    phone_number: "+49 123 456789",
    license_plate: "M-AB 123",
    password: "password123",
    registration_source: "ios", // oder 'web', 'android', 'apple_signin'
  }),
});
```

### Login-Quelle wird automatisch erkannt:

```javascript
fetch("api/login_user.php", {
  method: "POST",
  headers: { "Content-Type": "application/json" },
  body: JSON.stringify({
    email: "max@example.com",
    password: "password123",
    registration_source: "ios", // Optional, wird automatisch erkannt
  }),
});
```

## Admin-Dashboard Integration

### 1. Widget einbinden

In `admin_dashboard.php` oder `admin/index.php`:

```php
<?php include 'widgets/user_registration_source_widget.php'; ?>
```

### 2. Benutzerliste mit Quelle anzeigen

In der User-Liste kannst du die Quelle anzeigen:

```php
<?php foreach ($users as $user): ?>
    <tr>
        <td><?php echo $user['registration_source']; ?></td>
        <td><?php echo $user['registration_device']; ?></td>
        <td><?php echo $user['last_login_source']; ?></td>
    </tr>
<?php endforeach; ?>
```

## Automatische Erkennung

Das System erkennt automatisch:

1. **Registrierungsquelle**:

   - Basierend auf `User-Agent` Header
   - Oder explizit übergebenen `registration_source` Parameter

2. **Device**:

   - iOS (iPhone, iPad, iPod)
   - Android
   - Windows, Mac, Linux
   - Mobile Browsers

3. **IP-Adresse**:
   - Real Client IP
   - Auch hinter Proxies korrekt

## Nächste Schritte

- [ ] Widget in Admin-Dashboard einbinden
- [ ] Registrierungsquellen-Filter in User-Liste
- [ ] Export-Funktion für Statistiken
- [ ] Login-Historie erweitern

---

**Version**: 1.0.0
**Status**: ✅ Implementiert
