# E-Mail-Verifikation Fix

## 🔧 Problem behoben

**Ursache**: SMTP-Daten wurden aus der falschen Tabelle geladen (`settings` statt `autohaus`)

**Lösung**: SMTP-Daten werden jetzt aus der `autohaus` Tabelle geladen

---

## ✅ Änderungen

### 1. **admin_approve_user.php** (Freischaltung)

```php
// VORHER (Falsch):
$stmt = $pdo->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key LIKE 'smtp_%'");

// NACHHER (Richtig):
$stmt = $pdo->prepare("
    SELECT email_smtp_host, email_smtp_port, email_smtp_username,
           email_smtp_password, email_smtp_encryption, email_from_name, name
    FROM autohaus
    WHERE is_active = 1 AND email_smtp_host IS NOT NULL AND email_smtp_host != ''
    ORDER BY id LIMIT 1
");
```

### 2. **admin_reject_user.php** (Ablehnung)

- Gleiche Änderung wie bei Freischaltung
- Lädt SMTP-Daten aus dem ersten aktiven Autohaus

---

## 📋 Wie es funktioniert

### **E-Mail-Versand bei Freischaltung/Ablehnung**

1. **SMTP-Daten laden**:

   - Aus `autohaus` Tabelle
   - Nur aktive Autohäuser mit konfigurierten SMTP-Daten
   - Erstes Autohaus wird verwendet

2. **PHPMailer mit Autohaus-SMTP**:

   ```php
   $mail->Host = $autohaus['email_smtp_host'];
   $mail->Username = $autohaus['email_smtp_username'];
   $mail->Password = $autohaus['email_smtp_password'];
   $mail->Port = $autohaus['email_smtp_port'] ?? 587;
   ```

3. **Fallback**:
   - Wenn kein Autohaus mit SMTP-Daten gefunden wird
   - Verwendet PHP `mail()` Funktion

---

## 🎯 Ergebnis

✅ **Freischaltungs-E-Mail**:

- Grünes Design
- Personalisierte Nachricht
- Button "Jetzt Termin buchen"
- Versendet via Autohaus-SMTP

✅ **Ablehnungs-E-Mail**:

- Rotes Design
- Ablehnungsgrund wird angezeigt
- Button "Neues Dokument hochladen"
- Versendet via Autohaus-SMTP

---

## 🔍 Debugging

### **Logs prüfen**

```
XAMPP: C:\xampp\apache\logs\error.log
```

### **Erfolgsmeldung**

```
Freischaltungs-E-Mail erfolgreich gesendet an: user@example.com via Autohaus-Name
Ablehnungs-E-Mail erfolgreich gesendet an: user@example.com via Autohaus-Name
```

### **Fehlermeldung**

```
E-Mail-Fehler beim Senden an user@example.com via Autohaus-Name: [Fehler]
```

---

## 📝 Voraussetzungen

1. **Autohaus mit SMTP-Daten**:

   ```sql
   SELECT * FROM autohaus
   WHERE is_active = 1
   AND email_smtp_host IS NOT NULL
   AND email_smtp_host != '';
   ```

2. **PHPMailer installiert**:

   - Ordner: `api/phpmailer/`
   - Dateien: `PHPMailer.php`, `SMTP.php`, `Exception.php`

3. **SMTP-Credentials korrekt**:
   - Host, Port, Username, Password
   - Encryption: tls/ssl

---

## ✅ Testen

1. Admin schaltet einen User frei
2. E-Mail sollte ankommen
3. Log-Datei prüfen: `error_log()`
4. User sollte E-Mail in Posteingang haben

---

## 🚨 Wichtig

- **Autohaus-SMTP muss konfiguriert sein**
- **Nur aktive Autohäuser** werden verwendet
- **Erstes gefundenes Autohaus** wird genutzt
- **Fallback auf PHP mail()** wenn kein SMTP

---

**Datum**: 2025-01-27
**Version**: 2.0.0
