# E-Mail-Test Anleitung

## 🧪 Test durchführen

### 1. **Test-URL öffnen**

```
http://localhost/boxenstop/api/test_email_verification.php?email=IhreTestEmail@example.com
```

**Wichtig**: Ersetzen Sie `IhreTestEmail@example.com` mit Ihrer eigenen E-Mail-Adresse!

---

### 2. **Was passiert?**

✅ **Erfolgs-Meldung**:

```
✅ ERFOLG: E-Mail wurde erfolgreich gesendet an: test@example.com
```

❌ **Fehler-Meldung**:

```
✗ FEHLER: [Fehlermeldung]
```

---

## 📋 Ausführliche Debug-Ausgabe

### **Log-Datei erstellen**

Nach dem Test wird eine Log-Datei erstellt:

```
logs/email_test_2025-01-27_14-30-45.log
```

### **Inhalt der Log-Datei**:

```
[2025-01-27 14:30:45] [INFO] === E-Mail Test gestartet ===
[2025-01-27 14:30:45] [INFO] 1. Lade Konfiguration...
[2025-01-27 14:30:45] [INFO] 2. Prüfe Autohaus-SMTP-Daten...
[2025-01-27 14:30:45] [INFO] 3. Gefundene Autohäuser: 1
[2025-01-27 14:30:45] [INFO] --- Autohaus: Kiel (ID: 1) ---
[2025-01-27 14:30:45] [INFO]   Active: Ja
[2025-01-27 14:30:45] [INFO]   SMTP Host: smtp-mail.outlook.com
[2025-01-27 14:30:45] [INFO]   SMTP Port: 587
[2025-01-27 14:30:45] [INFO]   SMTP Username: rentacar-kiel@be-automobile.de
[2025-01-27 14:30:45] [INFO]   SMTP Password: GESETZT
[2025-01-27 14:30:45] [INFO]   4. Verwende Autohaus: Kiel für E-Mail-Versand
[2025-01-27 14:30:45] [INFO]   5. Teste PHPMailer-Installation...
[2025-01-27 14:30:45] [INFO]   ✓ PHPMailer ist verfügbar
[2025-01-27 14:30:45] [INFO]   6. Erstelle Test-E-Mail...
[2025-01-27 14:30:45] [INFO]   7. Starte PHPMailer...
[2025-01-27 14:30:45] [INFO]   8. Konfiguriere SMTP...
[2025-01-27 14:30:45] [DEBUG] SMTP Debug: CONNECT smtp-mail.outlook.com:587
[2025-01-27 14:30:46] [DEBUG] SMTP Debug: 220 mail.outlook.com
[2025-01-27 14:30:46] [INFO]   ✅ ERFOLG: E-Mail wurde erfolgreich gesendet
[2025-01-27 14:30:46] [INFO] === Test beendet ===
```

---

## 🔍 Häufige Probleme

### **Problem 1: "Kein Autohaus mit SMTP-Daten"**

**Fehler**:

```
FEHLER: Kein Autohaus mit konfigurierten SMTP-Daten gefunden!
```

**Lösung**:

```sql
-- Prüfen Sie die SMTP-Daten in der Datenbank
SELECT id, name, email_smtp_host, email_smtp_port, email_smtp_username, is_active
FROM autohaus
WHERE is_active = 1;
```

### **Problem 2: "PHPMailer nicht verfügbar"**

**Fehler**:

```
PHPMailer ist NICHT verfügbar
```

**Lösung**:

- Prüfen Sie, ob `api/phpmailer/` Ordner existiert
- Prüfen Sie, ob Dateien `PHPMailer.php`, `SMTP.php`, `Exception.php` vorhanden sind

### **Problem 3: "SMTP-Fehler"**

**Fehler**:

```
SMTP Debug: Could not authenticate
```

**Lösung**:

1. Prüfen Sie SMTP-Credentials in der Datenbank
2. Prüfen Sie, ob SMTP-Server erreichbar ist
3. Prüfen Sie Firewall-Einstellungen

---

## 🎯 Nächste Schritte

### **1. Test-E-Mail empfangen?**

✅ **Ja**:

- E-Mail-System funktioniert!
- SMTP-Konfiguration ist korrekt
- Weiter zum nächsten Schritt

❌ **Nein**:

- Log-Datei prüfen
- SMTP-Daten überprüfen
- Firewall prüfen

### **2. Freischaltung/Ablehnung testen**

1. **Admin-Dashboard öffnen**
2. **User freischalten oder ablehnen**
3. **E-Mail sollte ankommen**
4. **Logs prüfen**: `api/php_errors.log`

---

## 📝 Log-Dateien prüfen

### **Test-Logs**:

```
logs/email_test_*.log
```

### **PHP Error Logs**:

```
C:\xampp\apache\logs\error.log
```

### **API-Logs**:

```
api/php_errors.log
```

---

## 🔧 Debug-Modus aktivieren

### **In test_email_verification.php**:

```php
$mail->SMTPDebug = 2; // Vollständige Debug-Ausgabe
```

### **In admin_approve_user.php**:

```php
$mail->SMTPDebug = 2; // Für Produktion auf 0 setzen!
```

---

## ✅ Checkliste

- [ ] Test-URL öffnen mit eigener E-Mail-Adresse
- [ ] Erfolgs-Meldung erscheint
- [ ] Test-E-Mail im Posteingang
- [ ] Log-Datei wird erstellt
- [ ] SMTP-Daten werden korrekt geladen
- [ ] PHPMailer funktioniert
- [ ] E-Mail-Versand funktioniert

---

**Hinweis**: Nach erfolgreichem Test sollten alle Freischaltungs- und Ablehnungs-E-Mails ebenfalls funktionieren!
