# E-Mail-System Dokumentation

## 📧 Überblick

Das Boxenstop-System verwendet mehrere E-Mail-Methoden je nach Kontext.

---

## 🔧 Aktuell verwendetes E-Mail-System

### 1. **Freischaltungs-Benachrichtigung** (`api/admin_approve_user.php`)

- **Methode**: PHPMailer mit SMTP
- **SMTP-Server**: Outlook (`smtp-mail.outlook.com`)
- **Port**: 587 (STARTTLS)
- **Absender**: `rentacar-kiel@be-automobile.de`
- **Fallback**: PHP `mail()` Funktion

### 2. **Offerte-E-Mail** (`api/send_offer_email.php`)

- **Methode**: PHPMailer mit SMTP
- **SMTP-Konfiguration**: Aus Datenbank (`autohaus` Tabelle)
- **Einstellungen**:
  - `email_smtp_host`
  - `email_smtp_port`
  - `email_smtp_username`
  - `email_smtp_password`
  - `email_smtp_encryption`

### 3. **Reifen-Offerte** (`api/send_tire_offer_email.php`)

- **Methode**: PHPMailer mit SMTP
- **Datenquelle**: Autohaus-Einstellungen aus Datenbank

---

## 📋 Verfügbare E-Mail-Services

### **PHPMailer**

- **Pfad**: `api/phpmailer/`
- **Verwendung**: Hauptmethode für alle wichtigen E-Mails
- **Features**:
  - SMTP-Unterstützung
  - HTML-E-Mails
  - Anhänge
  - Fehlerbehandlung

### **SendGrid** (`api/sendgrid_notifications.php`)

- **API**: SendGrid v3
- **Status**: Verfügbar, aber nicht standardmäßig aktiv
- **Key**: Gespeichert in `settings` Tabelle

### **Gmail SMTP** (`api/gmail_notifications.php`)

- **Server**: `smtp.gmail.com`
- **Port**: 465 (SSL)
- **Auth**: `duludag16@gmail.com`
- **Status**: Verfügbar als Alternative

### **SwiftMailer** (`api/swiftmailer_notifications.php`)

- **Status**: Verfügbar als Alternative
- **SMTP**: Outlook (`smtp-mail.outlook.com`)

---

## 🔒 SMTP-Konfiguration (aktuell)

### **Outlook SMTP** (Standard)

```
Host: smtp-mail.outlook.com
Port: 587
Encryption: STARTTLS
Username: rentacar-kiel@be-automobile.de
Password: W@050373011206af
```

### **Gmail SMTP** (Alternative)

```
Host: smtp.gmail.com
Port: 465
Encryption: SSL/TLS
Username: duludag16@gmail.com
Password: [In Credentials gespeichert]
```

---

## 📝 E-Mail-Templates

### **Freischaltungs-E-Mail** (`api/admin_approve_user.php`)

- **Betreff**: "Ihr Konto wurde freigeschaltet - Boxenstop"
- **Format**: HTML
- **Inhalt**:
  - ✅ Erfolgs-Banner
  - 👤 Personalisierte Begrüßung
  - 📋 Liste der freigeschalteten Funktionen
  - 🔗 CTA-Button "Jetzt Termin buchen"
  - 📧 Footer mit Firmeninformationen

---

## 🎯 Verwendung

### **Freischaltungs-Benachrichtigung senden**

Wenn ein Admin einen Benutzer freischaltet:

```php
1. Admin klickt auf "Freischalten"
2. api/admin_approve_user.php wird aufgerufen
3. verification_status wird auf 'approved' gesetzt
4. E-Mail wird automatisch gesendet mit:
   - User-Daten (Name, E-Mail)
   - HTML-Template
   - SMTP-Konfiguration aus Datenbank
```

### **E-Mail-Versand-Methoden**

1. **PHPMailer** (Bevorzugt)

   - SMTP-Unterstützung
   - Zuverlässiger Versand
   - Bessere Fehlerbehandlung

2. **PHP mail()** (Fallback)
   - Einfache Funktion
   - Keine SMTP-Authentifizierung
   - Weniger zuverlässig

---

## 📊 E-Mail-Status-Tracking

### **Protokollierung**

- Erfolgreich: `error_log("Freischaltungs-E-Mail erfolgreich gesendet an: " . $to);`
- Fehler: `error_log("E-Mail-Fehler beim Senden an " . $to . ": " . $e->getMessage());`

### **Log-Speicherort**

- XAMPP: `C:\xampp\apache\logs\error.log`
- PHP: `php_errors.log`

---

## 🔧 Konfiguration anpassen

### **SMTP-Einstellungen ändern**

Option 1: Datenbank

```sql
UPDATE settings
SET setting_value = 'IhreSMTPHost'
WHERE setting_key = 'smtp_host';
```

Option 2: Code-Anpassung

```php
// In api/admin_approve_user.php
$mail->Host = 'IhreSMTPHost';
$mail->Username = 'IhreSMTPBenutzername';
$mail->Password = 'IhrSMTPPasswort';
```

---

## 🚨 Wichtige Hinweise

### **Sicherheit**

- ⚠️ **Kein hartcodiertes Passwort**: SMTP-Passwort in Code nur temporär für Fallback
- ✅ **Verwenden Sie Umgebungsvariablen**: Für Produktion
- 🔒 **SMTP-Credentials**: In Datenbank oder `.env` Datei speichern

### **Testen**

```php
// Debug-Modus aktivieren
$mail->SMTPDebug = 2; // Zeigt alle SMTP-Kommandos
```

### **Produktion**

```php
// Debug-Modus deaktivieren
$mail->SMTPDebug = 0; // Keine Debug-Ausgabe
```

---

## 📌 Checkliste

- ✅ PHPMailer installiert in `api/phpmailer/`
- ✅ SMTP-Konfiguration in Datenbank
- ✅ Fallback auf PHP `mail()`
- ✅ HTML-Template für Freischaltungs-E-Mail
- ✅ Fehlerprotokollierung aktiviert
- ✅ Personalisierte E-Mails mit User-Namen

---

## 🔄 Nächste Schritte

### **Empfohlen**

1. SMTP-Credentials in `.env` Datei auslagern
2. E-Mail-Templates in separaten Dateien speichern
3. E-Mail-Warteschlange für zuverlässige Zustellung
4. E-Mail-Status-Dashboard für Admin

### **Optional**

- SendGrid API für bessere Zustellrate
- E-Mail-Templates im Admin-Bereich bearbeiten
- Automatische E-Mail-Benachrichtigungen bei Status-Änderungen

---

## 📞 Support

Bei Fragen oder Problemen:

- SMTP-Logs: `php_errors.log`
- PHPMailer-Docs: https://github.com/PHPMailer/PHPMailer
- SendGrid-Docs: https://docs.sendgrid.com/

---

**Zuletzt aktualisiert**: 2025-01-27
**Version**: 1.0.0
