# Backend-Routes Übersicht

## 📍 Überblick

Diese Dokumentation listet alle aktuell verwendeten Backend-Routes im Boxenstop-Projekt auf.

---

## 🔐 Authentifizierung & User Management

### Login & Registrierung

#### `POST /api/login_user.php`

- **Zweck**: Benutzer-Anmeldung (Email/Password oder Apple Sign-In)
- **Verwendung**: `login.php`, iOS Apps
- **Parameter**:
  - `email` (string)
  - `password` (string)
  - `apple_token` (optional, für Apple Sign-In)
- **Response**:
  - `success` (boolean)
  - `user` (object)
  - `auth_token` (string) - 30-Tage-Gültigkeit

#### `POST /api/register_user.php`

- **Zweck**: Neue Benutzer-Registrierung
- **Verwendung**: `login.php`, iOS Apps
- **Parameter**:
  - `name` (string)
  - `email` (string)
  - `password` (string)
  - `phone` (string, optional)
  - `license_plate` (string, optional)
  - `registration_source` (string) - "web", "ios", "apple"
  - `registration_device` (string)
  - `registration_ip` (string)
- **Response**:
  - `success` (boolean)
  - `user` (object)
  - `message` (string)
- **Features**:
  - Automatische IP & Device-Erkennung
  - Setzt `verification_status` auf `pending`

#### `POST /api/logout.php`

- **Zweck**: Benutzer-Abmeldung
- **Verwendung**: Überall
- **Parameter**: Keine
- **Response**: `success`

#### `GET /api/check_user_exists.php`

- **Zweck**: Prüft ob Email bereits registriert ist
- **Verwendung**: `login.php`
- **Parameter**: `email` (query)
- **Response**: `exists` (boolean)

#### `GET /api/get_user_status.php`

- **Zweck**: Gibt Benutzer-Status zurück
- **Verwendung**: `index.php`, `profile.php`
- **Parameter**: Keine (Session)
- **Response**:
  - `logged_in` (boolean)
  - `user` (object)
  - `verification_status` (string)

---

## ✅ Benutzer-Verifikation

#### `GET /api/get_pending_users.php`

- **Zweck**: Liste aller unverifizierten Benutzer
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**: Keine
- **Response**: `users` (array)

#### `POST /api/admin_approve_user.php`

- **Zweck**: Admin freischalten eines Benutzers
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `user_id` (int)
- **Response**:
  - `success` (boolean)
  - `message` (string)
- **Aktion**: Setzt `verification_status = 'approved'` und `status = 'approved'`

#### `POST /api/admin_reject_user.php`

- **Zweck**: Admin ablehnen eines Benutzers
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `user_id` (int)
  - `reason` (string) - Ablehnungsgrund
- **Response**:
  - `success` (boolean)
  - `message` (string)
- **Aktion**: Setzt `verification_status = 'rejected'` und `status = 'rejected'`

#### `POST /api/upload_verification_document.php`

- **Zweck**: Benutzer lädt Verifikationsdokument hoch
- **Verwendung**: `profile.php`
- **Parameter**:
  - `document` (file)
- **Response**:
  - `success` (boolean)
  - `file_path` (string)
- **Speicherort**: `/uploads/verification_documents/`

---

## 🚗 Fahrzeug-Management

#### `GET /api/get_vehicle.php`

- **Zweck**: Lädt Fahrzeug-Informationen
- **Verwendung**: `profile.php`, `booking.php`
- **Parameter**:
  - `vehicle_id` (int)
- **Response**: `vehicle` (object)

#### `POST /api/add_vehicle.php`

- **Zweck**: Fügt ein neues Fahrzeug hinzu
- **Verwendung**: `profile.php`, iOS Apps
- **Parameter**:
  - `license_plate` (string)
  - `brand` (string, optional)
  - `model` (string, optional)
  - `year` (int, optional)
- **Response**:
  - `success` (boolean)
  - `vehicle_id` (int)

#### `POST /api/update_vehicle.php`

- **Zweck**: Aktualisiert ein Fahrzeug
- **Verwendung**: `profile.php`, iOS Apps
- **Parameter**:
  - `vehicle_id` (int)
  - `license_plate` (string)
  - `brand` (string, optional)
  - `model` (string, optional)
  - `year` (int, optional)
- **Response**: `success` (boolean)

#### `POST /api/delete_vehicle.php`

- **Zweck**: Löscht ein Fahrzeug
- **Verwendung**: `profile.php`, iOS Apps
- **Parameter**:
  - `vehicle_id` (int)
- **Response**: `success` (boolean)

---

## 👤 Profil-Management

#### `POST /api/update_user.php`

- **Zweck**: Aktualisiert Benutzer-Informationen
- **Verwendung**: `profile.php`, iOS Apps
- **Parameter**:
  - `name` (string)
  - `email` (string)
  - `phone` (string, optional)
  - `password` (string, optional)
- **Response**:
  - `success` (boolean)
  - `message` (string)

#### `POST /api/upload_profile_image.php`

- **Zweck**: Lädt Profilbild hoch
- **Verwendung**: `profile.php`, iOS Apps
- **Parameter**:
  - `image` (file)
- **Response**:
  - `success` (boolean)
  - `image_path` (string)

#### `GET /api/get_user_profile.php`

- **Zweck**: Lädt vollständiges Benutzer-Profil
- **Verwendung**: `profile.php`, iOS Apps
- **Parameter**: Keine (Session)
- **Response**:
  - `user` (object)
  - `vehicles` (array)
  - `verification_status` (string)

---

## 📅 Terminbuchung

#### `GET /api/get_autohauser.php`

- **Zweck**: Liste aller Autohäuser
- **Verwendung**: `index.php`
- **Parameter**: Keine
- **Response**: `autohauser` (array)

#### `GET /api/get_autohaus_services.php`

- **Zweck**: Services eines Autohauses
- **Verwendung**: `index.php`
- **Parameter**:
  - `autohaus_id` (int)
- **Response**: `services` (array)

#### `GET /api/get_event_slots.php`

- **Zweck**: Verfügbare Termin-Slots
- **Verwendung**: `booking.php`
- **Parameter**:
  - `autohaus_id` (int)
  - `event_id` (int)
  - `date` (string)
- **Response**: `slots` (array)

#### `GET /api/get_slot_counts.php`

- **Zweck**: Anzahl verfügbarer Slots
- **Verwendung**: `index.php`
- **Parameter**:
  - `autohaus_id` (int)
  - `event_id` (int)
- **Response**: `counts` (object)

---

## 🔧 Admin-Dashboard (Admin-Ordner)

#### `POST /admin/api/update_user_data.php`

- **Zweck**: Admin aktualisiert Benutzer-Daten
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `user_id` (int)
  - `field` (string)
  - `value` (mixed)
- **Response**: `success` (boolean)

#### `POST /admin/api/suspend_user.php`

- **Zweck**: Benutzer sperren
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `user_id` (int)
  - `reason` (string)
- **Response**:
  - `success` (boolean)
  - `message` (string)

#### `POST /admin/api/admin_document_action.php`

- **Zweck**: Admin-Aktion auf Dokumenten
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `action` (string) - "approve", "reject", "delete"
  - `document_id` (int)
- **Response**: `success` (boolean)

#### `GET /admin/api/get_user_documents.php`

- **Zweck**: Lädt Benutzer-Dokumente
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `user_id` (int)
- **Response**: `documents` (array)

#### `GET /admin/api/view_document.php`

- **Zweck**: Dokument anzeigen
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `file` (string)
- **Response**: Datei-Output

#### `POST /admin/api/save_admin_notes.php`

- **Zweck**: Admin-Notizen speichern
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**:
  - `user_id` (int)
  - `notes` (string)
- **Response**: `success` (boolean)

#### `GET /admin/api/dashboard-stats.php`

- **Zweck**: Dashboard-Statistiken
- **Verwendung**: `admin/admin_dashboard.php`
- **Parameter**: Keine
- **Response**:
  - `total_users` (int)
  - `pending_users` (int)
  - `approved_users` (int)
  - `rejected_users` (int)

---

## 📊 Weitere Features

#### `POST /api/save_user_session.php`

- **Zweck**: Speichert Benutzer-Session
- **Verwendung**: iOS Apps
- **Parameter**:
  - `auth_token` (string)
- **Response**: `success` (boolean)

#### `POST /api/user_verification_api.php`

- **Zweck**: Legacy Verifikations-API
- **Verwendung**: Legacy-Code
- **Parameter**: Variabel
- **Response**: Variabel

---

## 🔒 Session & Auth

### Session-Management

- **PHP-Sessions**: Für Web-Browser
- **auth_token**: Für iOS Apps (30 Tage Gültigkeit)
- **Session-Dateien**: PHP-Temp

### Admin-Sessions

- **PHP-Sessions**: Separate Admin-Session
- **Session-Key**: `admin_logged_in`
- **Session-User-ID**: `admin_user_id`

---

## 📁 Datei-Struktur

### Upload-Ordner

```
uploads/
  ├── verification_documents/  (Verifikationsdokumente)
  ├── profile_images/          (Profilbilder)
  └── temp/                     (Temporäre Dateien)
```

### API-Ordner

```
api/                           (Öffentliche API)
admin/api/                     (Admin-API)
```

---

## 🔐 Sicherheit

### Authentifizierung

- **User-Login**: Session-basiert für Web
- **Admin-Login**: Session-basiert mit separater Session
- **API-Auth**: Optional über `auth_token`

### Zugriffsrechte

- **Public API**: Keine Auth erforderlich
- **Admin API**: Nur für Admin-Session
- **User API**: Benutzer-Login erforderlich

---

## 📝 Wichtige Hinweise

### Verifikation-Workflow

1. ✅ Benutzer registriert sich
2. ⏳ Verifikation-Status: `pending`
3. 📄 Benutzer lädt Dokument hoch
4. 👁️ Admin sieht Benutzer in Dashboard
5. ✅ Admin freischalten
6. 🎉 Benutzer kann buchen

### API-Kompatibilität

- **Web**: Session-basiert
- **iOS**: Token-basiert
- **REST**: JSON-Responses
- **CORS**: Aktiviert für alle Origin

---

## 🔄 Zuletzt aktualisiert

- **Datum**: 2025-01-27
- **Version**: 1.0.0
- **Autor**: Boxenstop Development Team

---

**📌 Hinweis**: Diese Dokumentation wird automatisch aktualisiert bei Änderungen in der Codebase.
