# Apple Sign-In Setup Guide

## 1. Apple Developer Console einrichten

### Schritt 1: Services ID erstellen

1. Gehen Sie zu https://developer.apple.com/account
2. Navigieren Sie zu **Certificates, Identifiers & Profiles**
3. Wählen Sie **Identifiers** aus
4. Klicken Sie auf das **+ Symbol**
5. Wählen Sie **Services IDs** aus
6. Klicken Sie auf **Continue**
7. Geben Sie eine **Description** ein: `B&E Boxenstop Login`
8. Geben Sie eine **Identifier** ein: z.B. `be.automobileapps.boxenstop`
   (Must be unique! Use reverse domain notation)
   ⚠️ WICHTIG: Der Identifier muss UNIQUE sein und in reverse domain notation!
9. Aktivieren Sie **Sign In with Apple**
10. Klicken Sie auf **Continue** und dann **Register**

### Schritt 2: Services ID konfigurieren

1. Finden Sie Ihre neu erstellte Services ID
2. Klicken Sie auf die **Checkbox** neben der Services ID
3. Klicken Sie auf **Configure** (neben Services IDs)
4. Unter **Website URLs**:
   - **Domains and Subdomains**: `be-automobileapps.de`
   - **Return URLs**: `https://be-automobileapps.de/api/apple_callback.php`
5. Klicken Sie auf **Save**
6. Klicken Sie auf **Continue** und dann **Done**

### Schritt 3: Key erstellen für JWT Signing

1. Gehen Sie zu **Keys** im linken Menü
2. Klicken Sie auf das **+ Symbol**
3. Geben Sie einen **Key Name** ein: `B&E Boxenstop Apple Sign-In Key`
4. Aktivieren Sie **Sign In with Apple**
5. Klicken Sie auf **Continue** → **Register**
6. **WICHTIG:** Laden Sie den Key herunter (.p8 Datei) - Sie können ihn nur einmal herunterladen!
7. Notieren Sie:
   - **Key ID**: z.B. `ABC123XYZ`
   - **Team ID**: z.B. `DEF456GHI`

## 2. Code anpassen

### login.php

Finden Sie diese Zeile (ca. Zeile 628):

```javascript
clientId: 'YOUR_APPLE_SERVICE_ID',
```

Ersetzen Sie `YOUR_APPLE_SERVICE_ID` mit Ihrer tatsächlichen Services ID:

```javascript
clientId: 'com.beautomobile.boxenstop', // Ihre Services ID
```

### redirectURI aktualisieren

Die Zeile sollte so aussehen:

```javascript
redirectURI: 'https://be-automobileapps.de/api/apple_callback.php',
```

## 3. apple_callback.php erstellen

Erstellen Sie die Datei: `api/apple_callback.php`

```php
<?php
/**
 * Apple Sign-In Callback Handler
 */

session_start();
require_once __DIR__ . '/../config/database.php';

header('Content-Type: text/html; charset=utf-8');

// Parse the callback
$code = $_GET['code'] ?? null;
$state = $_GET['state'] ?? null;

if (!$code || !$state) {
    die('Fehler: Ungültiger Callback');
}

// Redirect zur Login-Seite mit Fehler
echo "<script>
    window.opener.postMessage({
        type: 'apple-signin-error',
        error: 'Callback received - Weiterleitung zur Verarbeitung'
    }, '*');

    setTimeout(() => {
        window.close();
    }, 1000);
</script>";

// Im echten System würden Sie hier:
// 1. Den Code gegen Tokens bei Apple austauschen
// 2. Die Tokens validieren
// 3. Den User in Ihrer Datenbank speichern oder anmelden
?>
```

## 4. Test

1. Gehen Sie zu Ihrer Website: `https://be-automobileapps.de/login.php`
2. Klicken Sie auf "Mit Apple anmelden"
3. Das Apple-Login-Fenster sollte sich öffnen
4. Nach erfolgreicher Anmeldung sollten Sie zurückgeleitet werden

## Troubleshooting

### "invalid_client" Fehler

- Stellen Sie sicher, dass die **Services ID** in `login.php` korrekt ist
- Stellen Sie sicher, dass die **Return URL** in der Apple Developer Console genau übereinstimmt
- Die Return URL muss exakt sein: `https://be-automobileapps.de/api/apple_callback.php`

### Weitere mögliche Probleme

- Domain muss in der Apple Developer Console verifiziert sein
- HTTPS ist erforderlich (nicht HTTP)
- Die Services ID muss korrekt erstellt und aktiviert sein

## Wichtige Informationen

**Ihre Services ID**: Geben Sie diese in `login.php` ein
**Return URL**: Muss exakt sein: `https://be-automobileapps.de/api/apple_callback.php`
**Domain**: `be-automobileapps.de`
