# AI Coding Agent Instructions for Boxxenstopp

```markdown
# AI Coding Agent Instructions — Boxxenstopp (concise)

Quick orientation

- Type: PHP app served from XAMPP (project under `C:\xampp\htdocs\boxenstop`). Use `start_boxxenstopp.bat` to run scheduled cleanup and helpers; open pages via Apache at http://localhost/<project-folder>.

Architecture & where to look

- Admin UI and logic: `admin/` (examples: `admin/index.php`, `admin/users.php`, `admin/install_quick_actions.html`).
- RESY integration: many variants live under root and `api/` (e.g. `resy.php`, `resy_reverse_engineering.php`, `api/resy_data_extraction*.php`). These implement multi-step login/navigation and scraping.
- Tests & experiments: standalone scripts at repo root (e.g. `test_resy_updated_search.php`, `test_session_management.php`) — run directly with PHP CLI for quick validation.

Developer workflows & quick commands

- Local dev: start XAMPP (Apache + PHP) or run `start_boxxenstopp.bat` from project root — it runs a token cleanup once and loops periodic cleanups (see file for details).
- Run a test script: `php .\test_resy_updated_search.php` (PowerShell syntax shown) — helpful to reproduce RESY flows.
- Inspect logs: primary runtime/debug log is `logs/resy_extraction.log`. Failed RESY attempts often dump HTML to PHP's temp dir (`sys_get_temp_dir()`).

Project-specific conventions

- Feature-first layout: each feature has its own PHP pages, docs and optional setup script (look for `setup_*` and `*_README.md`).
- DB migrations are ad-hoc SQL/PHP scripts (e.g., `setup_quick_actions.php`, `database_performance_indexes.sql`). Check docs before schema edits.
- Avoid changing vendor code under `vendor/`; TCPDF (`vendor/tcpdf/`) and PHPMailer are vendored and used directly.

Integration points & gotchas

- RESY scraping: sessions/cookies are crucial (cookies may be stored in `resy_cookies.txt` or DB). Check `api/resy_*` variants for session persistence patterns.
- Logging & debug dumps: `logs/resy_extraction.log` is the first place to look. HTML dumps go to `sys_get_temp_dir()` when enabled.
- Start script: `start_boxxenstopp.bat` does periodic cleanup using `cleanup_expired_tokens.php`; it does not start PHP's built-in server so Apache must be used.

Concrete examples to cite

- Reproduce RESY debug run: `php .\test_resy_updated_search.php` and then tail `logs/resy_extraction.log`.
- Install quick actions: open `admin/install_quick_actions.html` in browser or run `php setup_quick_actions.php`.
- Scoring reference: `admin/INTELLIGENT_SCORING_SYSTEM.md` (contains formulas and where PHP reads them).

When editing

- Preserve logging and HTML-dump behavior in RESY flows — they are the primary debugging aid.
- Use existing setup scripts for DB changes instead of ad-hoc direct SQL where possible.

Files worth reading first

- `admin/`, `resy.php`, `resy_reverse_engineering.php`, `api/resy_data_extraction.php*`, `setup_quick_actions.php`, `logs/resy_extraction.log`, `test_resy_updated_search.php`, `vendor/tcpdf/`.

If anything here is unclear or you'd like extra detail (RESY flows, DB schema, or scoring), say which area and I'll expand.
```
