<?php
/**
 * Einfacher Test der Login-Funktion
 */

echo "<h1>Einfacher Login-Test</h1>";

// Simuliere den API-Aufruf
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['CONTENT_TYPE'] = 'application/json';

$testData = json_encode(['action' => 'login', 'appointment_id' => 89]);

echo "<h2>Test-Daten:</h2>";
echo "<pre>" . $testData . "</pre>";

echo "<h2>API-Ausgabe:</h2>";
echo "<pre>";

// Include der API
ob_start();
include 'api/resy_data_extraction_real_html.php';
$output = ob_get_clean();

echo $output . "\n\n";

$decoded = json_decode($output, true);
if ($decoded) {
    echo "Decoded JSON:\n";
    print_r($decoded);
} else {
    echo "JSON Decode Error: " . json_last_error_msg() . "\n";
}

echo "</pre>";

echo "<h2>Log-Datei (letzte 30 Zeilen):</h2>";
echo "<pre>";
if (file_exists('logs/resy_extraction.log')) {
    $lines = file('logs/resy_extraction.log');
    $lastLines = array_slice($lines, -30);
    echo implode('', $lastLines);
} else {
    echo "Log-Datei nicht gefunden.";
}
echo "</pre>";
?>
