<?php
/**
 * Test der Datenbankverbindung für RESY-Credentials
 */

require_once 'config/database.php';

echo "<h1>Datenbankverbindung Test</h1>";

try {
    $db = new Database();
    $conn = $db->getConnection();
    echo "<p style='color: green;'>✅ Datenbankverbindung erfolgreich!</p>";
    
    // Teste Autohaus-Daten für Appointment ID 89
    echo "<h2>Autohaus-Daten für Appointment ID 89:</h2>";
    
    $stmt = $conn->prepare("
        SELECT a.id, a.name, a.resy_username, a.resy_password, a.resy_base_url 
        FROM autohaus a 
        JOIN appointments ap ON a.id = ap.autohaus_id 
        WHERE ap.id = 89
    ");
    $stmt->execute();
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($autohaus) {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Feld</th><th>Wert</th></tr>";
        foreach ($autohaus as $key => $value) {
            if ($key === 'resy_password') {
                $value = str_repeat('*', strlen($value));
            }
            echo "<tr><td>$key</td><td>$value</td></tr>";
        }
        echo "</table>";
        
        // Teste URL-Format
        echo "<h3>URL-Test:</h3>";
        $baseUrl = $autohaus['resy_base_url'];
        echo "<p>Base URL: <strong>$baseUrl</strong></p>";
        
        if (filter_var($baseUrl, FILTER_VALIDATE_URL)) {
            echo "<p style='color: green;'>✅ URL ist gültig!</p>";
        } else {
            echo "<p style='color: red;'>❌ URL ist ungültig!</p>";
        }
        
        // Teste Login-URL
        $loginUrl = $baseUrl . '/index.php?m=login&a=login';
        echo "<p>Login URL: <strong>$loginUrl</strong></p>";
        
        if (filter_var($loginUrl, FILTER_VALIDATE_URL)) {
            echo "<p style='color: green;'>✅ Login-URL ist gültig!</p>";
        } else {
            echo "<p style='color: red;'>❌ Login-URL ist ungültig!</p>";
        }
        
    } else {
        echo "<p style='color: red;'>❌ Keine Autohaus-Daten für Appointment ID 89 gefunden!</p>";
        
        // Zeige alle verfügbaren Appointments
        echo "<h3>Verfügbare Appointments:</h3>";
        $stmt = $conn->prepare("SELECT id, autohaus_id FROM appointments LIMIT 10");
        $stmt->execute();
        $appointments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Appointment ID</th><th>Autohaus ID</th></tr>";
        foreach ($appointments as $appointment) {
            echo "<tr><td>{$appointment['id']}</td><td>{$appointment['autohaus_id']}</td></tr>";
        }
        echo "</table>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Datenbankfehler: " . $e->getMessage() . "</p>";
}
?>
