<?php
// Test-Datei für die Reifenstatus-API
header('Content-Type: text/html; charset=utf-8');

echo "<h1>Reifenstatus-API Test</h1>";

// Test mit FormData (wie im Frontend verwendet)
echo "<h2>Test 1: FormData-Format</h2>";

$formData = [
    'storage_number' => '9.716.991',
    'appointment_date' => '2025-01-15',
    'event_name' => 'Reifenstatus-Prüfung'
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => 'http://172.24.10.114:8080/api/check_tire_status.php',
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $formData,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "<p><strong>HTTP Code:</strong> $httpCode</p>";
echo "<p><strong>cURL Error:</strong> " . ($error ?: 'Kein Fehler') . "</p>";
echo "<p><strong>Response Length:</strong> " . strlen($response) . " Zeichen</p>";

// JSON validieren
$jsonData = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "<p><strong>JSON Status:</strong> ✅ Gültig</p>";
    echo "<p><strong>Success:</strong> " . ($jsonData['success'] ? 'Ja' : 'Nein') . "</p>";
    if (isset($jsonData['error'])) {
        echo "<p><strong>Error:</strong> " . htmlspecialchars($jsonData['error']) . "</p>";
    }
} else {
    echo "<p><strong>JSON Status:</strong> ❌ Ungültig - " . json_last_error_msg() . "</p>";
    echo "<p><strong>Response Preview:</strong></p>";
    echo "<pre>" . htmlspecialchars(substr($response, 0, 500)) . "</pre>";
}

echo "<hr>";

// Test mit JSON (wie ursprünglich verwendet)
echo "<h2>Test 2: JSON-Format</h2>";

$jsonData = [
    'storage_number' => '9.716.991',
    'appointment_date' => '2025-01-15',
    'event_name' => 'Reifenstatus-Prüfung'
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => 'http://172.24.10.114:8080/api/check_tire_status.php',
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($jsonData),
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "<p><strong>HTTP Code:</strong> $httpCode</p>";
echo "<p><strong>cURL Error:</strong> " . ($error ?: 'Kein Fehler') . "</p>";
echo "<p><strong>Response Length:</strong> " . strlen($response) . " Zeichen</p>";

// JSON validieren
$jsonData = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "<p><strong>JSON Status:</strong> ✅ Gültig</p>";
    echo "<p><strong>Success:</strong> " . ($jsonData['success'] ? 'Ja' : 'Nein') . "</p>";
    if (isset($jsonData['error'])) {
        echo "<p><strong>Error:</strong> " . htmlspecialchars($jsonData['error']) . "</p>";
    }
} else {
    echo "<p><strong>JSON Status:</strong> ❌ Ungültig - " . json_last_error_msg() . "</p>";
    echo "<p><strong>Response Preview:</strong></p>";
    echo "<pre>" . htmlspecialchars(substr($response, 0, 500)) . "</pre>";
}

echo "<hr>";

// Test mit relativer URL
echo "<h2>Test 3: Relative URL (direkter Aufruf)</h2>";

// Simuliere den direkten Aufruf der API
$_POST['storage_number'] = '9.716.991';
$_POST['appointment_date'] = '2025-01-15';
$_POST['event_name'] = 'Reifenstatus-Prüfung';

// Capture output
ob_start();
include 'api/check_tire_status.php';
$response = ob_get_clean();

echo "<p><strong>Response Length:</strong> " . strlen($response) . " Zeichen</p>";

// JSON validieren
$jsonData = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "<p><strong>JSON Status:</strong> ✅ Gültig</p>";
    echo "<p><strong>Success:</strong> " . ($jsonData['success'] ? 'Ja' : 'Nein') . "</p>";
    if (isset($jsonData['error'])) {
        echo "<p><strong>Error:</strong> " . htmlspecialchars($jsonData['error']) . "</p>";
    }
    if (isset($jsonData['data'])) {
        echo "<p><strong>Data Keys:</strong> " . implode(', ', array_keys($jsonData['data'])) . "</p>";
    }
} else {
    echo "<p><strong>JSON Status:</strong> ❌ Ungültig - " . json_last_error_msg() . "</p>";
    echo "<p><strong>Response Preview:</strong></p>";
    echo "<pre>" . htmlspecialchars(substr($response, 0, 500)) . "</pre>";
}

echo "<hr>";
echo "<p><strong>Test abgeschlossen!</strong></p>";
?>