<?php
/**
 * Einfacher Test für resy_image_proxy.php
 */

// Simuliere GET-Parameter
$_GET['lgfoto_id'] = '75767';
$_GET['appointment_id'] = '89';

echo "<h1>Einfacher Test für resy_image_proxy.php</h1>";

echo "<h2>GET Parameter:</h2>";
echo "<pre>";
print_r($_GET);
echo "</pre>";

echo "<h2>Test URL:</h2>";
$testUrl = "http://100.82.207.72:8080/api/resy_image_proxy.php?lgfoto_id=75767&appointment_id=89";
echo "<a href='$testUrl' target='_blank'>$testUrl</a>";

echo "<h2>Test mit cURL:</h2>";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Code: $httpCode</p>";
echo "<p>Response Headers:</p>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

echo "<h2>Test mit vollständigem Response:</h2>";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Code: $httpCode</p>";
echo "<p>Response (erste 500 Zeichen):</p>";
echo "<pre>" . htmlspecialchars(substr($response, 0, 500)) . "</pre>";

echo "<h2>Log-Datei prüfen:</h2>";
$logFile = __DIR__ . '/logs/resy_image_proxy.log';
if (file_exists($logFile)) {
    echo "<p>Log-Datei gefunden: $logFile</p>";
    $logContent = file_get_contents($logFile);
    $lines = explode("\n", $logContent);
    $recentLines = array_slice($lines, -10); // Letzte 10 Zeilen
    echo "<pre>" . htmlspecialchars(implode("\n", $recentLines)) . "</pre>";
} else {
    echo "<p>Log-Datei nicht gefunden: $logFile</p>";
}
?>
