<?php
// Test mit separaten Dateien für jede Nummer - Profiltiefen-Details
echo "=== TEST MIT SEPARATEN DATEIEN FÜR PROFILTIEFEN-DETAILS ===\n\n";

$testNumbers = ['9717187', '9717187', '9717187', '9717187', '9716625'];

foreach ($testNumbers as $index => $storageNumber) {
    echo "Test " . ($index + 1) . ": $storageNumber\n";
    
    // Erstelle separate Test-Datei
    $testFile = "test_profiltiefen_$index.php";
    $content = "<?php
// Test für Einlagerungsnummer $storageNumber - Profiltiefen-Details
\$_SERVER['REQUEST_METHOD'] = 'POST';
\$_POST = ['storage_number' => '$storageNumber'];
\$_GET = [];
\$_REQUEST = ['storage_number' => '$storageNumber'];

ob_start();
include 'admin/api/check_tire_status_real_resy.php';
\$response = ob_get_clean();

\$jsonData = json_decode(\$response, true);

if (\$jsonData && \$jsonData['success']) {
    \$data = \$jsonData['data'];
    echo \"✅ ERFOLGREICH - $storageNumber\\n\";
    echo \"📋 ALLGEMEINE DATEN:\\n\";
    echo \"  • Einlagerungsnummer: \" . (\$data['einlagerungsnummer'] ?? 'N/A') . \"\\n\";
    echo \"  • Kennzeichen: \" . (\$data['kennzeichen'] ?? 'N/A') . \"\\n\";
    echo \"  • Haltername: \" . (\$data['haltername'] ?? 'N/A') . \"\\n\";
    echo \"  • Eingangsdatum: \" . (\$data['eingangsdatum'] ?? 'N/A') . \"\\n\";
    echo \"  • Serviceart: \" . (\$data['serviceart'] ?? 'N/A') . \"\\n\";
    echo \"  • FIN: \" . (\$data['fin'] ?? 'N/A') . \"\\n\\n\";
    
    echo \"🛞 DETAILLIERTE REIFENDATEN:\\n\";
    \$tirePositions = ['reifen_vl', 'reifen_vr', 'reifen_hl', 'reifen_hr'];
    
    foreach (\$tirePositions as \$pos) {
        if (isset(\$data[\$pos])) {
            \$tire = \$data[\$pos];
            echo \"\\n📍 \" . strtoupper(\$pos) . \" (\" . (\$tire['position'] ?? \$pos) . \"):\\n\";
            echo \"  • Marke: \" . (\$tire['marke'] ?? 'N/A') . \"\\n\";
            echo \"  • Modell: \" . (\$tire['modell'] ?? 'N/A') . \"\\n\";
            echo \"  • Größe: \" . (\$tire['groesse'] ?? 'N/A') . \"\\n\";
            echo \"  • Art: \" . (\$tire['art'] ?? 'N/A') . \"\\n\";
            echo \"  • DOT: \" . (\$tire['dot'] ?? 'N/A') . \"\\n\";
            
            if (isset(\$tire['profiltiefe'])) {
                \$prof = \$tire['profiltiefe'];
                echo \"  📏 PROFILTIEFEN:\\n\";
                echo \"    • Innen (I): \" . (\$prof['i'] ?? 'N/A') . \"mm\\n\";
                echo \"    • Mitte (M): \" . (\$prof['m'] ?? 'N/A') . \"mm\\n\";
                echo \"    • Außen (A): \" . (\$prof['a'] ?? 'N/A') . \"mm\\n\";
                
                if (\$prof['i'] && \$prof['m'] && \$prof['a']) {
                    \$avg = (floatval(\$prof['i']) + floatval(\$prof['m']) + floatval(\$prof['a'])) / 3;
                    echo \"    • Durchschnitt: \" . number_format(\$avg, 1) . \"mm\\n\";
                    
                    \$zustand = '';
                    if (\$avg >= 4) {
                        \$zustand = 'Sehr gut (4+ mm)';
                    } elseif (\$avg >= 2) {
                        \$zustand = 'Befriedigend (2-4 mm)';
                    } else {
                        \$zustand = 'Kritisch (<2 mm)';
                    }
                    echo \"    • Zustand: \$zustand\\n\";
                }
            } else {
                echo \"  📏 PROFILTIEFEN: N/A\\n\";
            }
            
            echo \"  💡 EMPFEHLUNG: \" . (\$tire['empfehlung'] ?? 'N/A') . \"\\n\";
            echo \"  🎯 ZUSTAND: \" . (\$tire['zustand'] ?? 'N/A') . \"\\n\";
        }
    }
    
    echo \"\\n📊 GESAMTÜBERSICHT:\\n\";
    \$totalTires = 0;
    \$totalProfiltiefe = 0;
    \$empfehlungen = [];
    
    foreach (\$tirePositions as \$pos) {
        if (isset(\$data[\$pos])) {
            \$tire = \$data[\$pos];
            \$totalTires++;
            
            if (isset(\$tire['profiltiefe']) && \$tire['profiltiefe']['i'] && \$tire['profiltiefe']['m'] && \$tire['profiltiefe']['a']) {
                \$avg = (floatval(\$tire['profiltiefe']['i']) + floatval(\$tire['profiltiefe']['m']) + floatval(\$tire['profiltiefe']['a'])) / 3;
                \$totalProfiltiefe += \$avg;
            }
            
            if (\$tire['empfehlung']) {
                \$empfehlungen[] = \$tire['empfehlung'];
            }
        }
    }
    
    if (\$totalTires > 0) {
        \$gesamtDurchschnitt = \$totalProfiltiefe / \$totalTires;
        echo \"  • Reifen gesamt: \$totalTires\\n\";
        echo \"  • Durchschnittliche Profiltiefe: \" . number_format(\$gesamtDurchschnitt, 1) . \"mm\\n\";
        echo \"  • Empfehlungen: \" . implode(', ', array_unique(\$empfehlungen)) . \"\\n\";
    }
} else {
    echo \"❌ FEHLER - $storageNumber\\n\";
    echo \"  • Error: \" . (\$jsonData['error'] ?? 'Unbekannt') . \"\\n\";
}
?>";
    
    file_put_contents($testFile, $content);
    
    // Führe Test aus
    $output = shell_exec("C:\\xampp\\php\\php.exe $testFile");
    echo $output;
    
    // Lösche Test-Datei
    unlink($testFile);
    
    echo "\n" . str_repeat("=", 70) . "\n\n";
}

echo "=== TEST ABGESCHLOSSEN ===\n";
?>
