<?php
/**
 * Vergleichstest zwischen orderTires API und check_tire_status API
 */

require_once 'config/database.php';

// Test-Einlagerungsnummer
$testNumber = '9.716.669';
$autohausId = 1;

echo "=== VERGLEICHSTEST: OrderTires vs CheckTireStatus ===\n";
echo "Test-Einlagerungsnummer: " . $testNumber . "\n";
echo "Autohaus ID: " . $autohausId . "\n\n";

// Test 1: OrderTires API direkt testen
echo "=== TEST 1: OrderTires API direkt ===\n";
try {
    require_once 'api/tire_order.php';
    $tireOrderService = new TireOrderService($autohausId);
    
    echo "OrderTires API: Starte Suche nach " . $testNumber . "...\n";
    
    // Nur die searchTireSet Methode testen (ohne Bestellung)
    $reflection = new ReflectionClass($tireOrderService);
    $searchMethod = $reflection->getMethod('searchTireSet');
    $searchMethod->setAccessible(true);
    
    $result = $searchMethod->invoke($tireOrderService, $testNumber);
    
    echo "OrderTires API Ergebnis:\n";
    echo "Success: " . ($result['success'] ? 'JA' : 'NEIN') . "\n";
    if (isset($result['error'])) {
        echo "Error: " . $result['error'] . "\n";
    }
    if (isset($result['lgs_id'])) {
        echo "LGS_ID: " . $result['lgs_id'] . "\n";
    }
    
} catch (Exception $e) {
    echo "OrderTires API Fehler: " . $e->getMessage() . "\n";
}

echo "\n";

// Test 2: CheckTireStatus API testen
echo "=== TEST 2: CheckTireStatus API ===\n";
try {
    require_once 'api/check_tire_status.php';
    $tireStatusService = new TireStatusService($autohausId);
    
    echo "CheckTireStatus API: Starte Suche nach " . $testNumber . "...\n";
    
    $result = $tireStatusService->checkTireStatus($testNumber);
    
    echo "CheckTireStatus API Ergebnis:\n";
    echo "Success: " . ($result['success'] ? 'JA' : 'NEIN') . "\n";
    if (isset($result['error'])) {
        echo "Error: " . $result['error'] . "\n";
    }
    if (isset($result['data'])) {
        echo "Daten gefunden: " . count($result['data']) . " Felder\n";
    }
    
} catch (Exception $e) {
    echo "CheckTireStatus API Fehler: " . $e->getMessage() . "\n";
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
?>
