<?php
echo "<h1>Direkter API Test</h1>";

// Test 1: Working API
echo "<h2>Test Working API</h2>";

$testData = json_encode(['action' => 'test']);

$context = stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => 'Content-Type: application/json',
        'content' => $testData
    ]
]);

$result = file_get_contents('http://localhost/api/resy_data_extraction_working.php', false, $context);

echo "<pre>";
echo "Request Data: " . $testData . "\n\n";
echo "Response: " . $result . "\n\n";

$decoded = json_decode($result, true);
if ($decoded) {
    echo "Decoded JSON:\n";
    print_r($decoded);
} else {
    echo "JSON Decode Error: " . json_last_error_msg() . "\n";
}
echo "</pre>";

// Test 2: Login Test
echo "<h2>Test Login</h2>";

$loginData = json_encode(['action' => 'login', 'appointment_id' => 1]);

$context = stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => 'Content-Type: application/json',
        'content' => $loginData
    ]
]);

$result = file_get_contents('http://localhost/api/resy_data_extraction_working.php', false, $context);

echo "<pre>";
echo "Request Data: " . $loginData . "\n\n";
echo "Response: " . $result . "\n\n";

$decoded = json_decode($result, true);
if ($decoded) {
    echo "Decoded JSON:\n";
    print_r($decoded);
} else {
    echo "JSON Decode Error: " . json_last_error_msg() . "\n";
}
echo "</pre>";

echo "<h2>Log-Datei</h2>";
echo "<pre>";
if (file_exists('logs/resy_extraction.log')) {
    echo file_get_contents('logs/resy_extraction.log');
} else {
    echo "Log-Datei nicht gefunden.";
}
echo "</pre>";
?>