<?php
// Simple autoloader for PHPMailer
spl_autoload_register(function ($class) {
    // Convert namespace to file path
    $file = str_replace('\\', DIRECTORY_SEPARATOR, $class);
    $file = str_replace('PHPMailer' . DIRECTORY_SEPARATOR . 'PHPMailer' . DIRECTORY_SEPARATOR, '', $file);
    
    // Look for the file in the phpmailer directory
    $phpmailerFile = __DIR__ . DIRECTORY_SEPARATOR . 'phpmailer' . DIRECTORY_SEPARATOR . $file . '.php';
    
    if (file_exists($phpmailerFile)) {
        require_once $phpmailerFile;
        return true;
    }
    
    return false;
});
?>
