<?php
/**
 * Bestehende Termine auf neue Status umstellen
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "Aktualisiere bestehende Termine...\n";
    
    // Alle Termine laden
    $stmt = $conn->prepare("SELECT id, status FROM appointments");
    $stmt->execute();
    $appointments = $stmt->fetchAll();
    
    $updated = 0;
    foreach ($appointments as $appointment) {
        $newStatus = 'pending'; // Standard für neue Anfragen
        
        // Bestehende Termine je nach aktuellem Status umstellen
        switch ($appointment['status']) {
            case 'booked':
                $newStatus = 'approved';
                break;
            case 'vorbereitet':
                $newStatus = 'approved';
                break;
            case 'completed':
                $newStatus = 'completed';
                break;
            case 'cancelled':
                $newStatus = 'cancelled';
                break;
            default:
                $newStatus = 'pending';
                break;
        }
        
        // Status aktualisieren
        $updateStmt = $conn->prepare("UPDATE appointments SET status = ? WHERE id = ?");
        $updateStmt->execute([$newStatus, $appointment['id']]);
        $updated++;
        
        echo "✅ Termin {$appointment['id']}: {$appointment['status']} → {$newStatus}\n";
    }
    
    echo "\n🎉 $updated Termine erfolgreich aktualisiert!\n";
    
    // Zeige Status-Übersicht
    $stmt = $conn->prepare("SELECT status, COUNT(*) as count FROM appointments GROUP BY status");
    $stmt->execute();
    $statusCounts = $stmt->fetchAll();
    
    echo "\n📊 Status-Übersicht:\n";
    foreach ($statusCounts as $status) {
        echo "- {$status['status']}: {$status['count']} Termine\n";
    }
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
}
?>
