<?php
/**
 * Test-Script für die aktualisierte RESY-Suchfunktion
 * Testet die neuen Suchmethoden gegen das aktualisierte RESY-System
 */

require_once 'api/resy_data_extraction_breakthrough.php';

// Test-Konfiguration
$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de/resyweb',
    'username' => 'test_user', // Ersetzen Sie mit echten Anmeldedaten
    'password' => 'test_password', // Ersetzen Sie mit echten Anmeldedaten
    'test_lgs_ids' => [
        '9877038', // Die LGS_ID aus der Fehlermeldung
        '9877131', // Eine andere Test-LGS_ID
        '9718476'  // Eine bekannte funktionierende LGS_ID
    ]
];

echo "=== RESY UPDATED SEARCH TEST ===\n";
echo "Base URL: " . $testConfig['base_url'] . "\n";
echo "Test LGS_IDs: " . implode(', ', $testConfig['test_lgs_ids']) . "\n\n";

foreach ($testConfig['test_lgs_ids'] as $lgsId) {
    echo "--- Testing LGS_ID: $lgsId ---\n";
    
    try {
        // Test 1: Neue Suchfunktion
        echo "🔄 Testing new search function...\n";
        $result1 = searchWithUpdatedResySystem($testConfig['base_url'], $lgsId);
        echo "✅ New search function SUCCESS: " . $result1['message'] . "\n";
        echo "   Found LGS_ID: " . $result1['lgs_id'] . "\n";
        echo "   Search type: " . $result1['search_type'] . "\n";
        
    } catch (Exception $e) {
        echo "❌ New search function FAILED: " . $e->getMessage() . "\n";
        
        try {
            // Test 2: Alternative Suchmethoden
            echo "🔄 Testing alternative search methods...\n";
            $result2 = searchWithAlternativeMethods($testConfig['base_url'], $lgsId);
            echo "✅ Alternative search methods SUCCESS: " . $result2['message'] . "\n";
            echo "   Found LGS_ID: " . $result2['lgs_id'] . "\n";
            echo "   Search method: " . $result2['search_method'] . "\n";
            
        } catch (Exception $e2) {
            echo "❌ Alternative search methods FAILED: " . $e2->getMessage() . "\n";
            
            try {
                // Test 3: Fallback-Suchlogik
                echo "🔄 Testing fallback search logic...\n";
                $result3 = searchWithOriginalLogic($testConfig['base_url'], $lgsId);
                echo "✅ Fallback search logic SUCCESS: " . $result3['message'] . "\n";
                echo "   Found LGS_ID: " . $result3['lgs_id'] . "\n";
                echo "   Search term: " . $result3['search_term'] . "\n";
                
            } catch (Exception $e3) {
                echo "❌ Fallback search logic FAILED: " . $e3->getMessage() . "\n";
            }
        }
    }
    
    echo "\n";
}

echo "=== TEST COMPLETED ===\n";
echo "Check the debug logs in: logs/resy_extraction.log\n";
echo "Check the HTML files in: " . sys_get_temp_dir() . "/\n";
?>
