<?php
/**
 * Test-Script für die Cache-Funktionalität
 */

echo "<h1>Test der Cache-Funktionalität</h1>\n";

// Test-Parameter
$testStorageNumber = '9877131'; // Beispiel-Storage-Number
$testAppointmentId = '89'; // Beispiel-Appointment-ID

echo "<h2>Test-Parameter:</h2>\n";
echo "<ul>\n";
echo "<li>Storage Number: $testStorageNumber</li>\n";
echo "<li>Appointment ID: $testAppointmentId</li>\n";
echo "</ul>\n";

// Test 1: Cache-Datenbank prüfen
echo "<h2>Test 1: Cache-Datenbank prüfen</h2>\n";
try {
    require_once __DIR__ . '/config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe resy_data_cache Tabelle
    $stmt = $conn->prepare("SELECT COUNT(*) as count FROM resy_data_cache WHERE einlagerungsnummer = ?");
    $stmt->execute([$testStorageNumber]);
    $dataCacheCount = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    
    echo "<p><strong>RESY Data Cache Einträge:</strong> $dataCacheCount</p>\n";
    
    // Prüfe resy_html_cache Tabelle
    $stmt = $conn->prepare("SELECT COUNT(*) as count FROM resy_html_cache WHERE einlagerungsnummer = ?");
    $stmt->execute([$testStorageNumber]);
    $htmlCacheCount = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    
    echo "<p><strong>RESY HTML Cache Einträge:</strong> $htmlCacheCount</p>\n";
    
    // Zeige Details der Cache-Einträge
    if ($dataCacheCount > 0) {
        echo "<h3>Data Cache Details:</h3>\n";
        $stmt = $conn->prepare("SELECT einlagerungsnummer, appointment_id, updated_at, expires_at FROM resy_data_cache WHERE einlagerungsnummer = ? ORDER BY updated_at DESC LIMIT 5");
        $stmt->execute([$testStorageNumber]);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' style='border-collapse: collapse;'>\n";
        echo "<tr><th>Storage Number</th><th>Appointment ID</th><th>Updated At</th><th>Expires At</th></tr>\n";
        foreach ($results as $row) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['einlagerungsnummer']) . "</td>";
            echo "<td>" . htmlspecialchars($row['appointment_id'] ?? 'NULL') . "</td>";
            echo "<td>" . htmlspecialchars($row['updated_at']) . "</td>";
            echo "<td>" . htmlspecialchars($row['expires_at']) . "</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }
    
    if ($htmlCacheCount > 0) {
        echo "<h3>HTML Cache Details:</h3>\n";
        $stmt = $conn->prepare("SELECT einlagerungsnummer, appointment_id, LENGTH(html_content) as html_length, updated_at, expires_at FROM resy_html_cache WHERE einlagerungsnummer = ? ORDER BY updated_at DESC LIMIT 5");
        $stmt->execute([$testStorageNumber]);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' style='border-collapse: collapse;'>\n";
        echo "<tr><th>Storage Number</th><th>Appointment ID</th><th>HTML Length</th><th>Updated At</th><th>Expires At</th></tr>\n";
        foreach ($results as $row) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['einlagerungsnummer']) . "</td>";
            echo "<td>" . htmlspecialchars($row['appointment_id'] ?? 'NULL') . "</td>";
            echo "<td>" . htmlspecialchars($row['html_length']) . " Zeichen</td>";
            echo "<td>" . htmlspecialchars($row['updated_at']) . "</td>";
            echo "<td>" . htmlspecialchars($row['expires_at']) . "</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Datenbankfehler: " . htmlspecialchars($e->getMessage()) . "</p>\n";
}

// Test 2: Cache-Funktionen testen
echo "<h2>Test 2: Cache-Funktionen testen</h2>\n";
try {
    require_once __DIR__ . '/api/resy_data_extraction_breakthrough.php';
    
    // Teste getCachedData
    echo "<h3>getCachedData Test:</h3>\n";
    $cachedData = getCachedData($testStorageNumber, $testAppointmentId);
    if ($cachedData) {
        echo "<p style='color: green;'>✅ Cache-Hit für Data Cache</p>\n";
        echo "<p>Vehicle Data Keys: " . implode(', ', array_keys($cachedData['vehicle_data'])) . "</p>\n";
        echo "<p>Tire Data Keys: " . implode(', ', array_keys($cachedData['tire_data'])) . "</p>\n";
    } else {
        echo "<p style='color: orange;'>⚠️ Cache-Miss für Data Cache</p>\n";
    }
    
    // Teste getCachedHtml
    echo "<h3>getCachedHtml Test:</h3>\n";
    $cachedHtml = getCachedHtml($testStorageNumber, $testAppointmentId);
    if ($cachedHtml) {
        echo "<p style='color: green;'>✅ Cache-Hit für HTML Cache</p>\n";
        echo "<p>HTML Length: " . $cachedHtml['length'] . " Zeichen</p>\n";
        echo "<p>Updated At: " . $cachedHtml['updated_at'] . "</p>\n";
        echo "<p>Expires At: " . $cachedHtml['expires_at'] . "</p>\n";
    } else {
        echo "<p style='color: orange;'>⚠️ Cache-Miss für HTML Cache</p>\n";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Cache-Funktions-Fehler: " . htmlspecialchars($e->getMessage()) . "</p>\n";
}

// Test 3: API-Aufruf testen
echo "<h2>Test 3: API-Aufruf testen</h2>\n";
$apiUrl = "http://localhost:8080/api/resy_data_extraction_breakthrough.php";

$testData = [
    'action' => 'get_cached_html',
    'appointment_id' => $testAppointmentId
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "<p><strong>HTTP Code:</strong> $httpCode</p>\n";
echo "<p><strong>Error:</strong> " . ($error ?: 'Keine') . "</p>\n";

if ($httpCode === 200) {
    $result = json_decode($response, true);
    if ($result && $result['success']) {
        echo "<p style='color: green;'>✅ API-Aufruf erfolgreich</p>\n";
        echo "<p><strong>HTML Length:</strong> " . strlen($result['html']) . " Zeichen</p>\n";
        echo "<p><strong>Message:</strong> " . htmlspecialchars($result['message']) . "</p>\n";
    } else {
        echo "<p style='color: red;'>❌ API-Fehler: " . htmlspecialchars($result['error'] ?? 'Unbekannter Fehler') . "</p>\n";
    }
} else {
    echo "<p style='color: red;'>❌ HTTP-Fehler: $httpCode</p>\n";
}

// Test 4: Log-Dateien prüfen
echo "<h2>Test 4: Log-Dateien prüfen</h2>\n";
$logFile = __DIR__ . '/logs/resy_extraction.log';
if (file_exists($logFile)) {
    $logContent = file_get_contents($logFile);
    $lines = explode("\n", $logContent);
    $recentLines = array_slice($lines, -30); // Letzte 30 Zeilen
    
    echo "<h3>Letzte 30 Log-Einträge:</h3>\n";
    echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ddd; max-height: 400px; overflow-y: auto;'>\n";
    foreach ($recentLines as $line) {
        if (!empty(trim($line))) {
            echo htmlspecialchars($line) . "\n";
        }
    }
    echo "</pre>\n";
} else {
    echo "<p style='color: red;'>Log-Datei nicht gefunden: $logFile</p>\n";
}

echo "<h2>Zusammenfassung</h2>\n";
echo "<p>Die Verbesserungen umfassen:</p>\n";
echo "<ul>\n";
echo "<li>✅ Verbesserte HTML-Cache-Validierung</li>\n";
echo "<li>✅ Bessere Fehlerbehandlung bei fehlenden HTML-Daten</li>\n";
echo "<li>✅ Detaillierteres Logging für Cache-Operationen</li>\n";
echo "<li>✅ Fallback-Mechanismen für Cache-Miss-Szenarien</li>\n";
echo "<li>✅ Längere Cache-Ablaufzeiten (24 Stunden)</li>\n";
echo "</ul>\n";

echo "<p><strong>Nächste Schritte:</strong></p>\n";
echo "<ol>\n";
echo "<li>Führen Sie 'Reifen prüfen' in der appointments.php durch</li>\n";
echo "<li>Prüfen Sie die Log-Dateien auf Cache-Hit/Miss-Informationen</li>\n";
echo "<li>Testen Sie die Bildladung nach den Cache-Verbesserungen</li>\n";
echo "</ol>\n";
?>
