<?php
/**
 * Test-Script für die behobene Cache-Funktionalität
 */

echo "<h1>Test der behobenen Cache-Funktionalität</h1>\n";

// Test-Parameter
$testStorageNumber = '9877131'; // Beispiel-Storage-Number
$testAppointmentId = '89'; // Beispiel-Appointment-ID

echo "<h2>Test-Parameter:</h2>\n";
echo "<ul>\n";
echo "<li>Storage Number: $testStorageNumber</li>\n";
echo "<li>Appointment ID: $testAppointmentId</li>\n";
echo "</ul>\n";

// Test 1: Cache-Tabellen prüfen
echo "<h2>Test 1: Cache-Tabellen prüfen</h2>\n";
try {
    require_once __DIR__ . '/config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe resy_data_cache Tabelle
    $stmt = $conn->query("SHOW TABLES LIKE 'resy_data_cache'");
    $dataCacheExists = $stmt->rowCount() > 0;
    
    // Prüfe resy_html_cache Tabelle
    $stmt = $conn->query("SHOW TABLES LIKE 'resy_html_cache'");
    $htmlCacheExists = $stmt->rowCount() > 0;
    
    echo "<p><strong>RESY Data Cache Tabelle:</strong> " . ($dataCacheExists ? '✅ Existiert' : '❌ Existiert nicht') . "</p>\n";
    echo "<p><strong>RESY HTML Cache Tabelle:</strong> " . ($htmlCacheExists ? '✅ Existiert' : '❌ Existiert nicht') . "</p>\n";
    
    if (!$dataCacheExists || !$htmlCacheExists) {
        echo "<p style='color: red;'><strong>❌ Cache-Tabellen fehlen!</strong> Führen Sie das Script 'setup/create_resy_cache_tables.php' aus.</p>\n";
        echo "<p><a href='setup/create_resy_cache_tables.php' target='_blank'>Cache-Tabellen erstellen</a></p>\n";
        exit;
    }
    
    // Zeige Tabellen-Struktur
    if ($dataCacheExists) {
        echo "<h3>Data Cache Struktur:</h3>\n";
        $stmt = $conn->query("DESCRIBE resy_data_cache");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "<ul>\n";
        foreach ($columns as $column) {
            echo "<li>" . $column['Field'] . " (" . $column['Type'] . ")</li>\n";
        }
        echo "</ul>\n";
    }
    
    if ($htmlCacheExists) {
        echo "<h3>HTML Cache Struktur:</h3>\n";
        $stmt = $conn->query("DESCRIBE resy_html_cache");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "<ul>\n";
        foreach ($columns as $column) {
            echo "<li>" . $column['Field'] . " (" . $column['Type'] . ")</li>\n";
        }
        echo "</ul>\n";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Datenbankfehler: " . htmlspecialchars($e->getMessage()) . "</p>\n";
}

// Test 2: Cache-Funktionen testen
echo "<h2>Test 2: Cache-Funktionen testen</h2>\n";
try {
    require_once __DIR__ . '/api/resy_data_extraction_breakthrough.php';
    
    // Teste getCachedData
    echo "<h3>getCachedData Test:</h3>\n";
    $cachedData = getCachedData($testStorageNumber, $testAppointmentId);
    if ($cachedData) {
        echo "<p style='color: green;'>✅ Cache-Hit für Data Cache</p>\n";
        echo "<p>Vehicle Data Keys: " . implode(', ', array_keys($cachedData['vehicle_data'])) . "</p>\n";
        echo "<p>Tire Data Keys: " . implode(', ', array_keys($cachedData['tire_data'])) . "</p>\n";
    } else {
        echo "<p style='color: orange;'>⚠️ Cache-Miss für Data Cache</p>\n";
    }
    
    // Teste getCachedHtml
    echo "<h3>getCachedHtml Test:</h3>\n";
    $cachedHtml = getCachedHtml($testStorageNumber, $testAppointmentId);
    if ($cachedHtml) {
        echo "<p style='color: green;'>✅ Cache-Hit für HTML Cache</p>\n";
        echo "<p>HTML Length: " . $cachedHtml['length'] . " Zeichen</p>\n";
        echo "<p>Updated At: " . $cachedHtml['updated_at'] . "</p>\n";
        echo "<p>Expires At: " . $cachedHtml['expires_at'] . "</p>\n";
    } else {
        echo "<p style='color: orange;'>⚠️ Cache-Miss für HTML Cache</p>\n";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Cache-Funktions-Fehler: " . htmlspecialchars($e->getMessage()) . "</p>\n";
}

// Test 3: API-Aufruf testen
echo "<h2>Test 3: API-Aufruf testen</h2>\n";
$apiUrl = "http://localhost:8080/api/resy_data_extraction_breakthrough.php";

$testData = [
    'action' => 'get_cached_html',
    'appointment_id' => $testAppointmentId
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "<p><strong>HTTP Code:</strong> $httpCode</p>\n";
echo "<p><strong>Error:</strong> " . ($error ?: 'Keine') . "</p>\n";

if ($httpCode === 200) {
    $result = json_decode($response, true);
    if ($result && $result['success']) {
        echo "<p style='color: green;'>✅ API-Aufruf erfolgreich</p>\n";
        echo "<p><strong>HTML Length:</strong> " . strlen($result['html']) . " Zeichen</p>\n";
        echo "<p><strong>Message:</strong> " . htmlspecialchars($result['message']) . "</p>\n";
    } else {
        echo "<p style='color: red;'>❌ API-Fehler: " . htmlspecialchars($result['error'] ?? 'Unbekannter Fehler') . "</p>\n";
    }
} else {
    echo "<p style='color: red;'>❌ HTTP-Fehler: $httpCode</p>\n";
}

// Test 4: Log-Dateien prüfen
echo "<h2>Test 4: Log-Dateien prüfen</h2>\n";
$logFile = __DIR__ . '/logs/resy_extraction.log';
if (file_exists($logFile)) {
    $logContent = file_get_contents($logFile);
    $lines = explode("\n", $logContent);
    $recentLines = array_slice($lines, -20); // Letzte 20 Zeilen
    
    echo "<h3>Letzte 20 Log-Einträge:</h3>\n";
    echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ddd; max-height: 400px; overflow-y: auto;'>\n";
    foreach ($recentLines as $line) {
        if (!empty(trim($line))) {
            echo htmlspecialchars($line) . "\n";
        }
    }
    echo "</pre>\n";
} else {
    echo "<p style='color: red;'>Log-Datei nicht gefunden: $logFile</p>\n";
}

echo "<h2>Zusammenfassung</h2>\n";
echo "<p>Die Verbesserungen umfassen:</p>\n";
echo "<ul>\n";
echo "<li>✅ Cache-Tabellen 'resy_data_cache' und 'resy_html_cache' erstellt</li>\n";
echo "<li>✅ Verbesserte Cache-Validierung mit Tabellen-Existenz-Prüfung</li>\n";
echo "<li>✅ Bessere Fehlerbehandlung bei Cache-Miss-Szenarien</li>\n";
echo "<li>✅ Detaillierteres Logging für alle Cache-Operationen</li>\n";
echo "<li>✅ Längere Cache-Ablaufzeiten (24 Stunden)</li>\n";
echo "</ul>\n";

echo "<p><strong>Nächste Schritte:</strong></p>\n";
echo "<ol>\n";
echo "<li>Führen Sie 'Reifen prüfen' in der appointments.php durch</li>\n";
echo "<li>Prüfen Sie die Log-Dateien auf Cache-Hit/Miss-Informationen</li>\n";
echo "<li>Testen Sie die Bildladung nach den Cache-Verbesserungen</li>\n";
echo "</ol>\n";

echo "<p style='color: green;'><strong>✅ Das Problem 'HTML-Inhalt fehlt' sollte jetzt behoben sein!</strong></p>\n";
?>
