<?php
/**
 * Setup Audit Tables
 * Führe dieses Script einmal aus, um die Audit-Tabellen zu erstellen
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "<h2>Audit-Tabellen Setup</h2>";
    
    // Create deleted_appointments_audit table
    $sql1 = "
        CREATE TABLE IF NOT EXISTS deleted_appointments_audit (
            id INT AUTO_INCREMENT PRIMARY KEY,
            original_appointment_id INT NOT NULL,
            customer_name VARCHAR(255) NOT NULL,
            license_plate VARCHAR(20) NOT NULL,
            phone VARCHAR(20),
            event_name VARCHAR(255),
            slot_date DATE,
            slot_time TIME,
            storage_number VARCHAR(50),
            tire_order_date DATETIME NULL,
            tire_cancelled BOOLEAN DEFAULT FALSE,
            tire_cancellation_date DATETIME NULL,
            deleted_by_user_id INT,
            deleted_by_username VARCHAR(100),
            deleted_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            deletion_reason TEXT,
            admin_notes TEXT,
            created_at DATETIME,
            updated_at DATETIME,
            INDEX idx_deleted_at (deleted_at),
            INDEX idx_deleted_by (deleted_by_user_id),
            INDEX idx_original_id (original_appointment_id)
        )
    ";
    
    $conn->exec($sql1);
    echo "<p>✅ Tabelle 'deleted_appointments_audit' erfolgreich erstellt/aktualisiert</p>";
    
    // Create tire_cancellations_audit table
    $sql2 = "
        CREATE TABLE IF NOT EXISTS tire_cancellations_audit (
            id INT AUTO_INCREMENT PRIMARY KEY,
            appointment_id INT NOT NULL,
            storage_number VARCHAR(50) NOT NULL,
            event_name VARCHAR(255),
            cancelled_by_user_id INT,
            cancelled_by_username VARCHAR(100),
            cancelled_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            cancellation_reason TEXT,
            resy_response TEXT,
            success BOOLEAN DEFAULT FALSE,
            error_message TEXT,
            INDEX idx_appointment_id (appointment_id),
            INDEX idx_cancelled_at (cancelled_at),
            INDEX idx_storage_number (storage_number)
        )
    ";
    
    $conn->exec($sql2);
    echo "<p>✅ Tabelle 'tire_cancellations_audit' erfolgreich erstellt/aktualisiert</p>";
    
    echo "<h3>Setup abgeschlossen!</h3>";
    echo "<p>Die Audit-Tabellen wurden erfolgreich erstellt. Du kannst jetzt das Löschsystem mit vollständiger Nachverfolgung verwenden.</p>";
    echo "<p><a href='admin/appointments.php'>Zurück zu den Terminen</a></p>";
    
} catch (Exception $e) {
    echo "<h2>Fehler beim Setup</h2>";
    echo "<p style='color: red;'>Fehler: " . $e->getMessage() . "</p>";
}
?>
