<?php
/**
 * Selenium WebDriver Setup und Test für RESY-System
 * 
 * Voraussetzungen:
 * 1. Chrome/Chromium Browser installiert
 * 2. ChromeDriver heruntergeladen und im PATH
 * 3. PHP WebDriver Bibliothek installiert
 */

echo "=== SELENIUM WEBDRIVER SETUP FÜR RESY-SYSTEM ===\n";

// Prüfe ob WebDriver verfügbar ist
if (!class_exists('Facebook\WebDriver\Remote\RemoteWebDriver')) {
    echo "❌ WebDriver nicht gefunden. Installation erforderlich:\n";
    echo "composer require facebook/webdriver\n";
    echo "oder\n";
    echo "composer require php-webdriver/webdriver\n";
    exit;
}

echo "✅ WebDriver verfügbar\n";

// Prüfe ChromeDriver
$chromeDriverPath = 'chromedriver.exe'; // Windows
if (PHP_OS_FAMILY === 'Linux') {
    $chromeDriverPath = 'chromedriver';
}

echo "Prüfe ChromeDriver: $chromeDriverPath\n";

if (!file_exists($chromeDriverPath)) {
    echo "❌ ChromeDriver nicht gefunden. Bitte herunterladen von:\n";
    echo "https://chromedriver.chromium.org/\n";
    echo "und in das Projektverzeichnis kopieren.\n";
    exit;
}

echo "✅ ChromeDriver gefunden\n";

// Teste ChromeDriver-Verbindung
try {
    $host = 'http://localhost:4444';
    echo "Teste Verbindung zu Selenium Server: $host\n";
    
    // Starte ChromeDriver (falls nicht läuft)
    $chromeDriverCommand = $chromeDriverPath . ' --port=4444';
    echo "Starte ChromeDriver: $chromeDriverCommand\n";
    
    // Führe ChromeDriver im Hintergrund aus
    if (PHP_OS_FAMILY === 'Windows') {
        $process = popen("start /B $chromeDriverCommand", 'r');
    } else {
        $process = popen("$chromeDriverCommand &", 'r');
    }
    
    sleep(2); // Warte auf Start
    
    echo "✅ ChromeDriver gestartet\n";
    
} catch (Exception $e) {
    echo "❌ ChromeDriver-Fehler: " . $e->getMessage() . "\n";
    echo "Stellen Sie sicher, dass ChromeDriver läuft:\n";
    echo "chromedriver --port=4444\n";
}

echo "\n=== SETUP ABGESCHLOSSEN ===\n";
echo "Nächste Schritte:\n";
echo "1. ChromeDriver starten: chromedriver --port=4444\n";
echo "2. Selenium-basierte RESY-Suche implementieren\n";
?>
