<?php
/**
 * Test mit robusterem Login und der funktionierenden LGS_ID 9716706
 */

echo "=== ROBUSTER LOGIN-TEST MIT FUNKTIONIERENDER LGS_ID ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'working_lgs_id' => '9716706'
];

echo "Base URL: " . $testConfig['base_url'] . "\n";
echo "Working LGS_ID: " . $testConfig['working_lgs_id'] . "\n\n";

try {
    $ch = curl_init();
    $cookieFile = sys_get_temp_dir() . '/resy_robust_test.txt';
    
    // Lösche alte Cookie-Datei
    if (file_exists($cookieFile)) {
        unlink($cookieFile);
    }
    
    echo "--- Schritt 1: Login-Seite laden ---\n";
    $loginUrl = $testConfig['base_url'] . '/index.php?m=login&a=login';
    
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    
    $loginPageResponse = curl_exec($ch);
    $loginPageCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    echo "Login-Seite: HTTP $loginPageCode\n";
    
    echo "--- Schritt 2: Login durchführen ---\n";
    $postData = [
        'FN' => 'login',
        'UserName' => $testConfig['username'],
        'Password' => $testConfig['password'],
        'button' => 'submit'
    ];
    
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'Referer: ' . $loginUrl
    ]);
    
    $loginResponse = curl_exec($ch);
    $loginCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $loginFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Login-Response: HTTP $loginCode\n";
    echo "Login-Final URL: $loginFinalUrl\n";
    echo "Login-Content Length: " . strlen($loginResponse) . " Zeichen\n";
    
    // Robuste Login-Validierung
    $hasLoginForm = strpos($loginResponse, 'Anmeldename') !== false || 
                    strpos($loginResponse, 'UserName') !== false;
    $hasResyContent = strpos($loginResponse, 'RESY') !== false ||
                     strpos($loginResponse, 'resyweb') !== false;
    $isOnMainPage = strpos($loginFinalUrl, 'resyweb') !== false;
    
    echo "Enthält Login-Form: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
    echo "Enthält RESY-Content: " . ($hasResyContent ? 'Ja' : 'Nein') . "\n";
    echo "Ist auf Hauptseite: " . ($isOnMainPage ? 'Ja' : 'Nein') . "\n";
    
    $loginSuccessful = !$hasLoginForm && ($hasResyContent || $isOnMainPage);
    
    if (!$loginSuccessful) {
        echo "❌ Login fehlgeschlagen - versuche trotzdem weiter\n";
    } else {
        echo "✅ Login erfolgreich!\n";
    }
    
    echo "\n--- Schritt 3: Teste direkte LGS_ID-URL ---\n";
    $directUrl = $testConfig['base_url'] . '/resyweb/index.php?m=wheelset&a=edit&LGS_ID=' . $testConfig['working_lgs_id'] . '&FN=WheelsetResult';
    echo "Direkte URL: $directUrl\n";
    
    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, null);
    curl_setopt($ch, CURLOPT_URL, $directUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Referer: ' . $loginFinalUrl
    ]);
    
    $directResponse = curl_exec($ch);
    $directCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $directFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Response Code: $directCode\n";
    echo "Final URL: $directFinalUrl\n";
    echo "Content Length: " . strlen($directResponse) . " Zeichen\n";
    
    // Speichere die Antwort
    file_put_contents(sys_get_temp_dir() . "/resy_robust_test.html", $directResponse);
    echo "Antwort gespeichert: " . sys_get_temp_dir() . "/resy_robust_test.html\n";
    
    // Detaillierte Analyse
    $hasLoginForm = strpos($directResponse, 'Anmeldename') !== false;
    $hasWheelsetData = strpos($directResponse, 'WheelHALTERNAME') !== false || 
                      strpos($directResponse, 'WheelKENNZEICHEN') !== false ||
                      strpos($directResponse, 'WheelFAHRGESTNR') !== false;
    $hasLgsId = strpos($directResponse, 'LGS_ID') !== false;
    $hasTargetLgsId = strpos($directResponse, $testConfig['working_lgs_id']) !== false;
    $hasResyContent = strpos($directResponse, 'RESY') !== false;
    
    echo "\n=== DETAILLIERTE ANALYSE ===\n";
    echo "Enthält Login-Form: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
    echo "Enthält LGS_ID: " . ($hasLgsId ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Ziel-LGS_ID: " . ($hasTargetLgsId ? 'Ja' : 'Nein') . "\n";
    echo "Enthält RESY-Content: " . ($hasResyContent ? 'Ja' : 'Nein') . "\n";
    
    if ($hasWheelsetData && $hasTargetLgsId) {
        echo "\n🎉 PERFEKT! Wheelset-Daten für LGS_ID {$testConfig['working_lgs_id']} gefunden!\n";
        echo "Die neue URL-Struktur funktioniert!\n";
    } elseif ($hasLoginForm) {
        echo "\n❌ Session verloren - zur Login-Seite umgeleitet\n";
        echo "Das Session-Management muss noch verbessert werden.\n";
    } elseif ($hasResyContent) {
        echo "\n⚠️ RESY-Seite erreicht, aber keine Wheelset-Daten\n";
        echo "Die LGS_ID existiert möglicherweise nicht oder hat andere Daten.\n";
    } else {
        echo "\n❓ Unbekannte Antwort - Details in der HTML-Datei\n";
    }
    
    // Zeige ersten Teil der Antwort
    echo "\n=== HTML-AUSSCHNITT (erste 500 Zeichen) ===\n";
    echo substr($directResponse, 0, 500) . "\n";
    
    curl_close($ch);
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
?>
