<?php
/**
 * Boxenstop - Volvo Autohaus Event Management
 * Hauptseite der Webapp
 */

session_start();
require_once 'config/database.php';
require_once 'includes/auth.php';

// Prüfen ob Einrichtung abgeschlossen ist
$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'setup_completed'");

// Wartungsmodus prüfen
$stmt_maintenance = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'maintenance_mode'");
$stmt_maintenance->execute();
$maintenance_mode = $stmt_maintenance->fetchColumn();
if ($maintenance_mode === '1') {
    // Launch-Datum aus DB holen
    $stmt_launch = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'launch_date'");
    $stmt_launch->execute();
    $launch_date = $stmt_launch->fetchColumn();
    $stmt_text = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'launch_date_text'");
    $stmt_text->execute();
    $launch_date_text = trim($stmt_text->fetchColumn() ?: '');
    if ($launch_date) {
        $launch_date_disp = date('d.m.Y', strtotime($launch_date));
        $headline = "Die neue B&E Onlinewelt<br>kommt am <span class=\"launch-date\">$launch_date_disp</span>";
    } elseif ($launch_date_text) {
        $launch_date_disp = $launch_date_text;
        $headline = "Die neue B&E Onlinewelt<br><span class=\"launch-date\">$launch_date_text</span>";
    } else {
        $launch_date_disp = 'Frühjahr 2026';
        $headline = "Die neue B&E Onlinewelt<br><span class=\"launch-date\">Frühjahr 2026</span>";
    }
    $year = date('Y');
    echo <<<HTML
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bald verfügbar – B&E Gruppe </title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body{margin:0;padding:0;min-height:100vh;box-sizing:border-box;font-family:Inter,sans-serif;background:#222;}
        .hero-bg{position:fixed;top:0;left:0;width:100vw;height:100vh;object-fit:cover;z-index:0;filter:brightness(0.7);background-image:url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/StartseitenSliderimage-Desktop-1312x514_processed.jpg');background-size:cover;background-position:center;}
        .overlay{position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.45);z-index:1;}
        .center-box{position:relative;z-index:2;display:flex;flex-direction:column;align-items:center;justify-content:center;height:100vh;backdrop-filter:blur(4px);}
        .branding{display:flex;align-items:center;gap:1.5rem;margin-bottom:2rem;}
        .branding img{height:38px;}
        .headline{color:#fff;font-size:2.7rem;font-weight:700;text-align:center;margin-bottom:1rem;letter-spacing:0.01em;}
        .headline .launch-date{display:block;color:#25d366;font-size:1.3rem;font-weight:500;margin-top:0.5rem;}
        .subline{color:#e0e7ef;font-size:1.3rem;text-align:center;margin-bottom:2.2rem;}
        .cta-btn{background:#fff;color:#222;font-weight:700;font-size:1.1rem;padding:1rem 2.2rem;border:none;border-radius:8px;box-shadow:0 2px 12px rgba(0,0,0,0.08);cursor:pointer;transition:background 0.2s;}
        .cta-btn:hover{background:#e0e7ef;}
        .footer{color:#bbb;font-size:1rem;margin-top:2.5rem;text-align:center;}
        @media(max-width:700px){.headline{font-size:1.4rem;}.subline{font-size:1rem;}.branding img{height:28px;}}
        .modal-lead{display:none;position:fixed;z-index:1000;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.55);align-items:center;justify-content:center;}
        .modal-lead.active{display:flex;}
        .modal-lead-content{background:#fff;border-radius:24px;max-width:410px;width:92vw;padding:2.5rem 2rem;box-shadow:0 12px 40px rgba(0,0,0,0.22);display:flex;flex-direction:column;align-items:center;position:relative;}
        .modal-lead-content h2{color:#003057;font-size:1.7rem;margin-bottom:1.2rem;text-align:center;font-weight:700;letter-spacing:0.01em;}
        .modal-lead-content .launch-date-info{color:#25d366;font-size:1.08rem;margin-bottom:0.7rem;text-align:center;}
        .modal-lead-content form{width:100%;display:flex;flex-direction:column;gap:1.1rem;align-items:center;}
        .modal-lead-content input[type=email]{width:100%;padding:0.8rem 1.1rem;border-radius:8px;border:1.5px solid #b0b8c1;font-size:1.08rem;transition:border 0.2s;}
        .modal-lead-content input[type=email]:focus{border:1.5px solid #003057;outline:none;}
        .modal-lead-content button[type=submit]{background:#003057;color:#fff;font-weight:700;padding:0.8rem 1.7rem;border:none;border-radius:8px;font-size:1.08rem;cursor:pointer;box-shadow:0 2px 8px rgba(0,0,0,0.08);transition:background 0.2s;}
        .modal-lead-content button[type=submit]:hover{background:#0056b3;}
        .modal-lead-content .lead-success{display:none;color:#28a745;font-size:1.08rem;margin-top:0.7rem;text-align:center;}
        .modal-lead-content .lead-error{display:none;color:#d00;font-size:1.08rem;margin-top:0.7rem;text-align:center;}
        .modal-lead-content hr{width:80%;margin:1.7rem 0 1.1rem 0;border:0;border-top:1px solid #eee;}
        .modal-lead-content a{color:#003057;font-size:1.08rem;text-decoration:none;transition:color 0.2s;}
        .modal-lead-content a.whatsapp{display:inline-flex;align-items:center;margin-bottom:1.1rem;color:#25d366;font-weight:700;font-size:1.13rem;gap:0.5rem;}
        .modal-lead-content a.whatsapp img{height:24px;vertical-align:middle;margin-right:7px;}
        .modal-lead-content .calendar-btn{display:inline-flex;align-items:center;gap:0.7em;background:#003057;color:#fff;font-weight:700;font-size:1.13rem;padding:0.9em 1.7em;border-radius:9px;margin:1.1em 0 0.5em 0;text-decoration:none;box-shadow:0 2px 12px rgba(0,0,0,0.10);transition:background 0.2s, box-shadow 0.2s;animation:pulse 1.8s infinite;}
        .modal-lead-content .calendar-btn:hover{background:#0056b3;box-shadow:0 4px 20px #25d36644;}
        @keyframes pulse{0%{box-shadow:0 0 0 0 #25d36644;}70%{box-shadow:0 0 0 10px #25d36611;}100%{box-shadow:0 0 0 0 #25d36600;}}
        .modal-lead-content .close-btn{margin-top:1.7rem;background:none;border:none;color:#888;font-size:1.13rem;cursor:pointer;transition:color 0.2s;}
        .modal-lead-content .close-btn:hover{color:#003057;}
        .modal-lead-content .volvo-info{margin-top:1.2rem;color:#003057;font-size:0.98rem;text-align:center;opacity:0.85;}
        .modal-lead-content .volvo-logo-modal{height:32px;margin-bottom:1.1rem;}
    </style>
</head>
<body>
    <div class="hero-bg" aria-hidden="true"></div>
    <div class="overlay" aria-hidden="true"></div>
    <div class="center-box">
        <div class="branding">
            <img src="assets/images/BE-Logo-FINAL_Schwarz-1.png" alt="B&E Gruppe Logo">
            <span style="color:#fff;font-size:1.1rem;letter-spacing:0.1em;">B&E Gruppe</span>
        </div>
    <div class="headline">$headline</div>
    <div class="subline">Wir bereiten alles für Sie vor.<br>Freuen Sie sich auf exklusive Angebote, Serviceleistungen und Probefahrten!</div>
        <button class="cta-btn" onclick="openLeadModal()" aria-haspopup="dialog" aria-controls="lead-modal">Jetzt vormerken</button>
        <div class="footer">&copy; {$year} B&E Gruppe</div>
    </div>
    <div id="lead-modal" class="modal-lead" role="dialog" aria-modal="true" aria-labelledby="lead-modal-title">
        <div class="modal-lead-content">
            <img src="assets/images/BE-Logo-FINAL_Schwarz-1.png" alt="B&E Gruppe Logo" class="volvo-logo-modal">
            <h2 id="lead-modal-title">Jetzt vormerken</h2>
            <div class="launch-date-info">Geplanter Launch: <strong>$launch_date_disp</strong></div>
            <form id="lead-form" autocomplete="email">
                <input type="email" name="email" id="lead-email" placeholder="Ihre E-Mail-Adresse" required aria-label="E-Mail-Adresse">
                <button type="submit">Benachrichtigen lassen</button>
                <div class="lead-success" id="lead-success">Danke! Wir informieren Sie zum Start.</div>
                <div class="lead-error" id="lead-error"></div>
            </form>
            <hr>
            <a href="https://wa.me/?text=Ich%20m%C3%B6chte%20informiert%20werden%2C%20sobald%20die%20neue%20Volvo%20Onlinewelt%20live%20ist!" target="_blank" class="whatsapp" rel="noopener"><img src="/assets/images/whatsapp.svg" alt="WhatsApp"> Per WhatsApp vormerken</a>
            <a href="/download_ics.php" class="calendar-btn" tabindex="0">
                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="none" viewBox="0 0 24 24" style="margin-right:0.5em;"><rect x="3" y="5" width="18" height="16" rx="3" fill="#fff" stroke="#fff" stroke-width="2"/><rect x="3" y="5" width="18" height="16" rx="3" fill="none" stroke="#003057" stroke-width="2"/><path d="M8 3v4M16 3v4" stroke="#003057" stroke-width="2" stroke-linecap="round"/><rect x="7" y="10" width="2" height="2" rx="1" fill="#003057"/><rect x="11" y="10" width="2" height="2" rx="1" fill="#003057"/><rect x="15" y="10" width="2" height="2" rx="1" fill="#003057"/></svg>
                Kalendereintrag speichern
            </a>
            <div class="volvo-info">Ihre Daten werden ausschließlich für die Benachrichtigung zum Launch verwendet.<br>by Deniz Uludag</div>
            <button class="close-btn" onclick="closeLeadModal()">Schließen</button>
        </div>
    </div>
    <script>
        function openLeadModal(){document.getElementById('lead-modal').classList.add('active');document.getElementById('lead-email').focus();}
        function closeLeadModal(){document.getElementById('lead-modal').classList.remove('active');}
        document.addEventListener('DOMContentLoaded',function(){
            var form=document.getElementById('lead-form');
            if(form)form.onsubmit=function(e){
                e.preventDefault();
                var email=document.getElementById('lead-email').value.trim();
                var success=document.getElementById('lead-success');
                var error=document.getElementById('lead-error');
                success.style.display='none';
                error.style.display='none';
                if(!email.match(/^.+@.+\..+$/)){
                    error.textContent='Bitte gültige E-Mail eingeben.';
                    error.style.display='block';
                    return;
                }
                var xhr=new XMLHttpRequest();
                xhr.open('POST','/boxenstop/save_lead.php');
                xhr.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
                xhr.onload=function(){
                    try{var res=JSON.parse(xhr.responseText);}catch(e){res={success:false,error:'Serverfehler'};}
                    if(res.success){
                        success.style.display='block';
                        form.reset();
                    }else{
                        error.textContent=res.error||'Fehler';
                        error.style.display='block';
                    }
                };
                xhr.send('email='+encodeURIComponent(email));
            };
            document.getElementById('lead-modal').onclick=function(e){if(e.target===this)closeLeadModal();};
        });
    </script>
</body>
</html>
HTML;
    exit;
}
$stmt->execute();
$setup_completed = $stmt->fetchColumn();

if (!$setup_completed) {
    header('Location: setup/');
    exit;
}

// Prüfe ob Multi-Autohaus-System aktiviert ist
$stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'multi_autohaus_enabled'");
$stmt->execute();
$multiAutohausEnabled = $stmt->fetchColumn();

// Autohäuser mit Event-Anzahl laden
$stmt = $conn->prepare("
    SELECT a.*, 
           COUNT(e.id) as event_count,
           COUNT(CASE WHEN e.event_date >= CURDATE() AND e.is_active = 1 THEN 1 END) as upcoming_events
    FROM autohaus a
    LEFT JOIN events e ON a.id = e.autohaus_id
    WHERE a.is_active = 1
    GROUP BY a.id, a.name, a.short_name, a.address, a.phone, a.email, a.footer_image, a.footer_image_alt
    ORDER BY a.name ASC
");
$stmt->execute();
$autohauser = $stmt->fetchAll();

// Aktive Events laden (mit Autohaus-Information)
$stmt = $conn->prepare("SELECT e.*, a.name as autohaus_name, a.short_name as autohaus_short_name,
    (SELECT COUNT(*) FROM appointments a WHERE a.event_id=e.id AND a.status IN ('booked','vorbereitet')) AS booked_count
  FROM events e 
  LEFT JOIN autohaus a ON e.autohaus_id = a.id
  WHERE e.is_active = 1 AND e.event_date >= CURDATE() 
  ORDER BY e.event_date ASC");
$stmt->execute();
$events = $stmt->fetchAll();

// Prüfe ob Autohaus-Auswahl erforderlich ist
$autohausSelectionRequired = false;
if ($multiAutohausEnabled) {
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'autohaus_selection_required'");
    $stmt->execute();
    $autohausSelectionRequired = $stmt->fetchColumn() == '1';
}

// Unternehmensdaten aus den Einstellungen laden
$stmt = $conn->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('company_name', 'company_phone', 'company_email', 'company_address', 'company_logo', 'app_name')");
$stmt->execute();
$companySettings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// Standardwerte setzen falls keine Einstellungen vorhanden
$companyName = $companySettings['company_name'] ?? 'B&E Gruppe';
$companyPhone = $companySettings['company_phone'] ?? '+49 (0) 123 456 789';
$companyEmail = $companySettings['company_email'] ?? 'info@volvo-autohaus.de';
$companyAddress = $companySettings['company_address'] ?? 'Musterstraße 123, 12345 Musterstadt';
$companyLogo = $companySettings['company_logo'] ?? 'assets/images/BE-Logo-FINAL_Schwarz-1.png';
// Entferne führenden Slash falls vorhanden
$companyLogo = ltrim($companyLogo, '/');
$appName = $companySettings['app_name'] ?? 'B&E Gruppe';
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
    <meta name="googlebot" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
    <meta name="bingbot" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
    <title><?php echo htmlspecialchars($appName); ?> - Volvo Autohaus</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/volvo-theme.css">
    
    <style>
        /* Autohaus-Auswahl Styles */
        .autohaus-selection-section {
            padding: 4rem 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .autohaus-selection-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 2rem;
            margin-top: 2rem;
        }
        
        .autohaus-selection-card {
            background: white;
            border-radius: 12px;
            padding: 2rem;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
        }
        
        .autohaus-selection-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            border-color: #007bff;
        }
        
        .autohaus-selection-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .autohaus-selection-card:hover::before {
            transform: scaleX(1);
        }
        
        .autohaus-card-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1.5rem;
        }
        
        .autohaus-card-header h3 {
            margin: 0;
            color: #495057;
            font-size: 1.25rem;
            font-weight: 600;
        }
        
        .autohaus-short {
            background: #007bff;
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .autohaus-card-info {
            margin-bottom: 1.5rem;
        }
        
        .autohaus-card-image {
            margin-bottom: 1.5rem;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .autohaus-card-info .info-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 0.75rem;
            color: #6c757d;
            font-size: 0.9rem;
        }
        
        .autohaus-card-info .info-item i {
            width: 16px;
            color: #007bff;
        }
        
        .autohaus-card-action {
            text-align: center;
            color: #007bff;
            font-size: 1.2rem;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .autohaus-selection-card:hover .autohaus-card-action {
            opacity: 1;
        }
        
        /* Autohaus-Filter */
        .autohaus-filter {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-top: 1rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }
        
        .autohaus-filter label {
            font-weight: 500;
            color: #495057;
            margin: 0;
        }
        
        .autohaus-filter select {
            padding: 0.5rem 1rem;
            border: 1px solid #ced4da;
            border-radius: 6px;
            background: white;
            font-size: 0.9rem;
            min-width: 200px;
        }
        
        /* Event-Autohaus-Info */
        .event-autohaus {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin: 0.5rem 0;
            padding: 0.5rem 0.75rem;
            background: #e3f2fd;
            border-radius: 6px;
            color: #1976d2;
            font-size: 0.9rem;
            font-weight: 500;
        }
        
        .event-autohaus i {
            color: #1976d2;
        }
        
        /* Ausgewähltes Autohaus Info */
        .selected-autohaus-info {
            margin-top: 1rem;
        }
        
        .autohaus-info-badge {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            background: #e3f2fd;
            border: 1px solid #bbdefb;
            border-radius: 8px;
            color: #1976d2;
        }
        
        .autohaus-info-badge i {
            font-size: 1.2rem;
        }
        
        .autohaus-info-badge span {
            flex: 1;
            font-weight: 500;
        }
        
        .btn-change-autohaus {
            background: #1976d2;
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            cursor: pointer;
            font-size: 0.9rem;
            transition: background 0.3s ease;
        }
        
        .btn-change-autohaus:hover {
            background: #1565c0;
        }
        
        .btn-change-autohaus i {
            margin-right: 0.5rem;
        }
        
        /* Keine Events Nachricht */
        .no-events-message {
            grid-column: 1 / -1;
            text-align: center;
            padding: 3rem 2rem;
            background: #f8f9fa;
            border-radius: 12px;
            border: 2px dashed #dee2e6;
            margin: 2rem 0;
        }
        
        .no-events-message .no-events-icon {
            font-size: 3rem;
            color: #6c757d;
            margin-bottom: 1rem;
        }
        
        .no-events-message h3 {
            color: #495057;
            margin-bottom: 1rem;
        }
        
        .no-events-message p {
            color: #6c757d;
            margin-bottom: 0.5rem;
        }
        
        @media (max-width: 768px) {
            .autohaus-selection-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }
            
            .autohaus-selection-card {
                padding: 1.5rem;
            }
            
            .autohaus-filter {
                flex-direction: column;
                align-items: stretch;
            }
            
            .autohaus-filter select {
                min-width: auto;
            }
        }
        
        /* Verbessertes Navigation Design - Volvo Style */
        .nav-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.625rem 1.25rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }
        
        .nav-link i {
            font-size: 1rem;
        }
        
        .user-link {
            background: #003057;
            color: white;
            border-color: #003057;
        }
        
        .user-link:hover {
            background: #0056b3;
            border-color: #0056b3;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 48, 87, 0.2);
        }
        
        .logout-link {
            background: #6c757d;
            color: white;
            border-color: #6c757d;
        }
        
        .logout-link:hover {
            background: #5a6268;
            border-color: #5a6268;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(108, 117, 125, 0.2);
        }
        
        .login-link {
            background: #0056b3;
            color: white;
            border-color: #0056b3;
        }
        
        .login-link:hover {
            background: #004085;
            border-color: #004085;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 86, 179, 0.2);
        }
        
        .admin-link {
            background: #fff;
            color: #495057;
            border-color: #dee2e6;
        }
        
        .admin-link:hover {
            background: #f8f9fa;
            border-color: #adb5bd;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        @media (max-width: 768px) {
            .nav-menu {
                flex-wrap: wrap;
                gap: 0.5rem;
            }
            
            .nav-link {
                padding: 0.625rem 1rem;
                font-size: 0.875rem;
            }
            
            .nav-link span {
                display: none;
            }
            
            .nav-link {
                width: 44px;
                height: 44px;
                justify-content: center;
                padding: 0;
            }
        }
        
        /* Hero Slideshow Styles werden jetzt aus style.css geladen */
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <div class="logo-wrapper">
                    <img src="<?php echo htmlspecialchars($companyLogo); ?>" alt="<?php echo htmlspecialchars($companyName); ?>" class="nav-logo">
                    <div class="brand-text">
                        <h1><?php echo htmlspecialchars($appName); ?></h1>
                        <span class="brand-subtitle">B&E Gruppe - Volvo Service<?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?> - Willkommen, <?php echo htmlspecialchars($_SESSION['user_name'] ?? 'User'); ?><?php endif; ?></span>
                    </div>
                </div>
            </div>
            <div class="nav-menu">
                <?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?>
                    <a href="profile.php" class="nav-link user-link">
                        <i class="fas fa-user"></i>
                        <span>Profil</span>
                    </a>
                    <a href="api/logout.php" class="nav-link logout-link">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>Abmelden</span>
                    </a>
                <?php else: ?>
                    <a href="login.php" class="nav-link login-link">
                        <i class="fas fa-sign-in-alt"></i>
                        <span>Anmelden</span>
                    </a>
                <?php endif; ?>
                <?php
                // Prüfe ob der eingeloggte User ein Admin ist
                $is_admin = false;
                if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] && isset($_SESSION['user_id'])) {
                    // Lade User-Daten
                    $stmt = $conn->prepare("SELECT id, email, admin_user_id FROM users WHERE id = ? AND is_active = 1");
                    $stmt->execute([$_SESSION['user_id']]);
                    $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if ($user_data) {
                        // Prüfe ob User direkt mit Admin verknüpft ist
                        if (!empty($user_data['admin_user_id'])) {
                            // Prüfe ob verknüpfter Admin aktiv ist
                            $stmt = $conn->prepare("SELECT id FROM admin_users WHERE id = ? AND is_active = 1");
                            $stmt->execute([$user_data['admin_user_id']]);
                            $admin_user = $stmt->fetch();
                            $is_admin = (bool)$admin_user;
                        } else {
                            // Fallback: Suche nach E-Mail in admin_users
                            $user_email = $user_data['email'] ?? '';
                            if (!empty($user_email)) {
                                $stmt = $conn->prepare("SELECT id FROM admin_users WHERE email = ? AND is_active = 1");
                                $stmt->execute([$user_email]);
                                $admin_user = $stmt->fetch();
                                $is_admin = (bool)$admin_user;
                            }
                        }
                    }
                }
                // Oder prüfe ob der User bereits als Admin eingeloggt ist
                if (!$is_admin && isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in']) {
                    $is_admin = true;
                }
                
                if ($is_admin):
                ?>
                <a href="admin/" class="nav-link admin-link">
                    <i class="fas fa-cog"></i>
                    <span>Admin</span>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Verifizierungs-Hinweis Banner -->
    <?php
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']) {
        $current_user = getCurrentUser();
        if ($current_user) {
            $verification_status = $current_user['verification_status'] ?? 'pending';
            
            if ($verification_status === 'pending' || $verification_status === 'rejected'): 
    ?>
    <div class="verification-alert" style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); border-left: 4px solid #ffc107; padding: 1.5rem 2rem; margin: 2rem auto; max-width: 1200px; border-radius: 12px; box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2); display: flex; align-items: center; gap: 1.5rem;">
        <div style="font-size: 2rem; color: #ffc107;">
            <i class="fas fa-hourglass-half"></i>
        </div>
        <div style="flex: 1;">
            <h3 style="margin: 0 0 0.5rem 0; color: #856404; font-weight: 700; font-size: 1.2rem;">
                Verifizierung erforderlich
            </h3>
            <p style="margin: 0; color: #856404; line-height: 1.6;">
                <?php if ($verification_status === 'pending'): ?>
                    Ihr Konto wartet noch auf Verifizierung. Bitte laden Sie ein Identitätsdokument in Ihrem <strong><a href="profile.php" style="color: #856404; text-decoration: underline;">Profil</a></strong> hoch, um Termine buchen zu können.
                <?php else: ?>
                    Ihr Konto wurde abgelehnt. Grund: <?php echo htmlspecialchars($current_user['verification_reason'] ?? 'Nicht angegeben'); ?>. Bitte laden Sie ein neues Dokument in Ihrem <strong><a href="profile.php" style="color: #856404; text-decoration: underline;">Profil</a></strong> hoch.
                <?php endif; ?>
            </p>
        </div>
        <div>
            <a href="verification_pending.php" class="btn" style="background: #ffc107; color: #856404; font-weight: 700; padding: 0.875rem 2rem; border-radius: 8px; text-decoration: none; display: inline-flex; align-items: center; gap: 0.5rem; transition: all 0.3s;">
                <i class="fas fa-arrow-right"></i>
                <span><?php echo $verification_status === 'rejected' ? 'Neues Dokument hochladen' : 'Dokument hochladen'; ?></span>
            </a>
        </div>
    </div>
    <?php
            endif;
        }
    }
    ?>

    <?php
    // Success Banner für Buchungsbestätigung - VOR der Hero Section
    if (isset($_GET['success']) && $_GET['success'] === 'request') {
        // Lade den letzten Appointment für den eingeloggten User
        if (isLoggedIn()) {
            $current_user = getCurrentUser();
            if ($current_user) {
                $stmt = $conn->prepare("
                    SELECT a.id, a.slot_date, a.slot_time, a.license_plate, e.name as event_name,
                           ah.name as autohaus_name, ah.address as autohaus_address
                    FROM appointments a
                    LEFT JOIN events e ON a.event_id = e.id
                    LEFT JOIN autohaus ah ON a.autohaus_id = ah.id
                    WHERE a.user_id = ? AND a.status = 'booked'
                    ORDER BY a.created_at DESC
                    LIMIT 1
                ");
                $stmt->execute([$current_user['id']]);
                $last_appointment = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($last_appointment):
    ?>
    <style>
    @media (max-width: 768px) {
        .success-banner .banner-container { 
            flex-direction: column !important;
            align-items: flex-start !important;
            gap: 1rem !important;
            padding: 0 1rem !important;
        }
        .success-banner .banner-actions { 
            width: 100% !important;
            flex-direction: column !important;
        }
        .success-banner .btn-download,
        .success-banner .btn-later {
            width: 100% !important;
            justify-content: center !important;
        }
        .success-banner {
            margin-top: 70px !important;
            padding: 0.75rem 0 !important;
        }
    }
    </style>
    <div class="success-banner" style="background: rgba(40, 167, 69, 0.1); border-top: 2px solid rgba(40, 167, 69, 0.3); border-bottom: 2px solid rgba(40, 167, 69, 0.3); padding: 1rem 0; margin-top: 80px; margin-bottom: 0; width: 100%; display: block; position: relative; z-index: 100;">
        <div class="banner-container" style="max-width: 1200px; margin: 0 auto; padding: 0 2rem; display: flex; align-items: center; gap: 1.5rem; flex-wrap: wrap;">
            <div class="banner-content" style="flex: 1; min-width: 200px;">
                <div class="banner-header" style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.5rem;">
                    <i class="fas fa-check-circle" style="font-size: 1.5rem; color: #28a745;"></i>
                    <h3 style="margin: 0; color: #155724; font-weight: 600; font-size: 1.1rem;">Termin erfolgreich gebucht</h3>
                </div>
                <p class="banner-text" style="margin: 0; color: #6c757d; font-size: 0.95rem; line-height: 1.4;">
                    <strong style="color: #003057;"><?php echo htmlspecialchars($last_appointment['license_plate']); ?></strong> 
                    am <?php echo date('d.m.Y', strtotime($last_appointment['slot_date'])); ?> 
                    um <?php echo date('H:i', strtotime($last_appointment['slot_time'])); ?> Uhr
                </p>
            </div>
            
            <div class="banner-actions" style="display: flex; gap: 0.75rem; flex-wrap: wrap;">
                <a href="download_appointment_ics.php?id=<?php echo $last_appointment['id']; ?>&_session=<?php echo session_id(); ?>" class="btn-download" style="background: #28a745; color: white; border: none; padding: 0.5rem 1rem; border-radius: 6px; text-decoration: none; font-weight: 500; font-size: 0.9rem; display: inline-flex; align-items: center; gap: 0.5rem; transition: all 0.2s ease;">
                    <i class="fas fa-download"></i>
                    In Kalender eintragen
                </a>
                <a href="profile.php#appointments" class="btn-later" style="background: transparent; color: #6c757d; border: 1px solid #dee2e6; padding: 0.5rem 1rem; border-radius: 6px; text-decoration: none; font-weight: 500; font-size: 0.9rem; display: inline-flex; align-items: center; gap: 0.5rem; transition: all 0.2s ease;">
                    <i class="fas fa-clock"></i>
                    Später
                </a>
            </div>
        </div>
    </div>
    <?php
                endif;
            }
        }
    }
    ?>

    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-slideshow">
            <div class="slide active" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/Startseitenslider-Image-Desktop_processed.jpg'); background-position: center center;"></div>
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/editionsmodellehome_processed.webp'); background-position: center center;"></div>
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/StartseitenSliderimage-Desktop_processed.jpg'); background-position: center center;"></div>
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/volvo_model_teaser/1963/Slider-BG3x_processed.png'); background-position: center center;"></div>
            <div class="slide" style="background-image: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/backgroundimage2x_processed.jpg'); background-position: center center;"></div>
        </div>
        <div class="hero-container">
            <div class="hero-content">
                <div class="hero-badge">
                    <i class="fas fa-shield-alt"></i>
                    <span>Professioneller Volvo Service</span>
                </div>
                <h1 class="hero-title">
                    <span class="title-line"><?php echo htmlspecialchars($appName); ?></span>
                    <span class="title-line">Service</span>
                </h1>
                <p class="hero-description">
                    Professioneller Reifenwechsel-Service für Ihren Volvo. 
                    Präzise, zuverlässig und mit höchster Qualität.
                </p>
                <div class="hero-stats">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-stopwatch"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-number">30</span>
                            <span class="stat-label">Minuten</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-number">2x</span>
                            <span class="stat-label">Jährlich</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Sicherheit</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Autohaus-Auswahl Section (nur wenn Multi-Autohaus aktiviert) -->
    <?php if ($multiAutohausEnabled && $autohausSelectionRequired): ?>
    <section class="autohaus-selection-section">
        <div class="section-container">
            <div class="section-header">
                <h2 class="section-title">Wählen Sie Ihr Autohaus</h2>
                <p class="section-subtitle">Bitte wählen Sie das Autohaus aus, für das Sie einen Termin buchen möchten</p>
            </div>
            
            <div class="autohaus-selection-grid">
                <?php foreach ($autohauser as $autohaus): ?>
                    <div class="autohaus-selection-card" onclick="selectAutohaus(<?php echo $autohaus['id']; ?>, '<?php echo htmlspecialchars($autohaus['name']); ?>')">
                        <div class="autohaus-card-header">
                            <h3><?php echo htmlspecialchars($autohaus['name']); ?></h3>
                            <span class="autohaus-short"><?php echo htmlspecialchars($autohaus['short_name']); ?></span>
                        </div>
                        <div class="autohaus-card-info">
                            <div class="info-item">
                                <i class="fas fa-map-marker-alt"></i>
                                <span><?php echo htmlspecialchars($autohaus['address']); ?></span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-phone"></i>
                                <span><?php echo htmlspecialchars($autohaus['phone']); ?></span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-calendar-alt"></i>
                                <span>
                                    <?php if ($autohaus['upcoming_events'] > 0): ?>
                                        <strong><?php echo $autohaus['upcoming_events']; ?></strong> Event<?php echo $autohaus['upcoming_events'] > 1 ? 's' : ''; ?> geplant
                                    <?php else: ?>
                                        Keine Events geplant
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                        <?php if (!empty($autohaus['footer_image'])): ?>
                        <div class="autohaus-card-image">
                            <img src="<?php echo htmlspecialchars($autohaus['footer_image']); ?>" 
                                 alt="<?php echo htmlspecialchars($autohaus['footer_image_alt'] ?? $autohaus['name']); ?>" 
                                 style="width: 100%; max-height: 150px; object-fit: cover; border-radius: 8px;">
                        </div>
                        <?php endif; ?>
                        <div class="autohaus-card-action">
                            <i class="fas fa-arrow-right"></i>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Events Section -->
    <section class="events-section" id="events-section" <?php echo ($multiAutohausEnabled && $autohausSelectionRequired) ? 'style="display: none;"' : ''; ?>>
        <div class="section-container">
            <div class="section-header">
                <h2 class="section-title">Verfügbare Events</h2>
                <p class="section-subtitle">Buchen Sie Ihren Termin bei der B&E Gruppe</p>
                <?php if ($multiAutohausEnabled && !$autohausSelectionRequired): ?>
                    <div class="autohaus-filter">
                        <label for="autohaus-filter">Autohaus filtern:</label>
                        <select id="autohaus-filter" onchange="filterEventsByAutohaus()">
                            <option value="">Alle Autohäuser</option>
                            <?php foreach ($autohauser as $autohaus): ?>
                                <option value="<?php echo $autohaus['id']; ?>"><?php echo htmlspecialchars($autohaus['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                <?php endif; ?>
            </div>
            
            <?php if (empty($events)): ?>
                <div class="no-events">
                    <div class="no-events-icon">
                        <i class="fas fa-calendar-times"></i>
                    </div>
                    <h3>Keine Events verfügbar</h3>
                    <p>Derzeit sind keine Events der B&E Gruppe geplant.</p>
                    <p>Kontaktieren Sie uns für weitere Informationen.</p>
                </div>
            <?php else: ?>
                <div class="events-grid">
                    <?php foreach ($events as $event): ?>
                        <?php
                        $totalSlots = floor((strtotime($event['end_time'])-strtotime($event['start_time']))/($event['slot_duration']*60)) * (int)$event['max_monteure'];
                        $booked = (int)($event['booked_count'] ?? 0);
                        $ratio = $totalSlots>0 ? round($booked/$totalSlots*100) : 0;
                        
                        // Nächster freier Slot ermitteln
                        $nextFree = null;
                        $countsStmt = $conn->prepare("SELECT slot_time, COUNT(*) as c FROM appointments WHERE event_id = ? AND slot_date = ? AND status IN ('booked','vorbereitet') GROUP BY slot_time");
                        $countsStmt->execute([$event['id'], $event['event_date']]);
                        $counts = [];
                        foreach ($countsStmt->fetchAll() as $row) { $counts[$row['slot_time']] = (int)$row['c']; }
                        $slotDur = ((int)$event['slot_duration']) * 60;
                        for ($t = strtotime($event['start_time']); $t < strtotime($event['end_time']); $t += $slotDur) {
                            $tStr = date('H:i:s', $t);
                            $b = $counts[$tStr] ?? 0;
                            if ($b < (int)$event['max_monteure']) { $nextFree = date('H:i', $t); break; }
                        }
                        ?>
                        <div class="event-card" data-autohaus-id="<?php echo $event['autohaus_id'] ?? ''; ?>">
                            <div class="event-card-header">
                                <div class="event-status">
                                    <span class="status-badge <?php echo $ratio >= 90 ? 'status-full' : ($ratio >= 70 ? 'status-busy' : 'status-available'); ?>">
                                        <?php echo $ratio >= 90 ? 'Ausgebucht' : ($ratio >= 70 ? 'Fast voll' : 'Verfügbar'); ?>
                                    </span>
                                </div>
                                <div class="event-date-badge">
                                    <i class="fas fa-calendar"></i>
                                    <span><?php echo date('d.m', strtotime($event['event_date'])); ?></span>
                                </div>
                            </div>
                            
                            <div class="event-card-content">
                                <h3 class="event-title"><?php echo htmlspecialchars($event['name']); ?></h3>
                                
                                <?php if (!empty($event['autohaus_name'])): ?>
                                <div class="event-autohaus">
                                    <i class="fas fa-building"></i>
                                    <span><?php echo htmlspecialchars($event['autohaus_name']); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                <div class="event-info-grid">
                                    <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Zeit</span>
                                            <span class="info-value"><?php echo date('H:i', strtotime($event['start_time'])); ?> - <?php echo date('H:i', strtotime($event['end_time'])); ?></span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-users"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Monteure</span>
                                            <span class="info-value"><?php echo $event['max_monteure']; ?></span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-stopwatch"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Slot-Dauer</span>
                                            <span class="info-value"><?php echo $event['slot_duration']; ?> Min</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-item">
                                        <div class="info-icon">
                                            <i class="fas fa-chart-pie"></i>
                                        </div>
                                        <div class="info-content">
                                            <span class="info-label">Auslastung</span>
                                            <span class="info-value"><?php echo $booked; ?>/<?php echo $totalSlots; ?></span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="event-progress">
                                    <div class="progress-header">
                                        <span class="progress-label">Belegung</span>
                                        <span class="progress-percentage"><?php echo $ratio; ?>%</span>
                                    </div>
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width: <?php echo $ratio; ?>%"></div>
                                    </div>
                                </div>
                                
                                <?php if ($nextFree): ?>
                                <div class="next-slot">
                                    <i class="fas fa-clock-rotate-left"></i>
                                    <span>Nächster freier Slot: <strong><?php echo $nextFree; ?></strong></span>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="event-card-footer">
                                <?php if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in']): ?>
                                    <?php 
                                    // Prüfe ob User verifiziert ist
                                    $current_user = getCurrentUser();
                                    $is_verified = $current_user && isset($current_user['verification_status']) && $current_user['verification_status'] === 'approved';
                                    $verification_status = $current_user['verification_status'] ?? 'pending';
                                    ?>
                                    <?php if ($is_verified): ?>
                                        <a href="booking.php?event=<?php echo $event['id']; ?>" class="btn btn-primary event-btn">
                                            <i class="fas fa-calendar-plus"></i>
                                            <span>Termin buchen</span>
                                        </a>
                                    <?php else: ?>
                                        <?php if ($verification_status === 'rejected'): ?>
                                            <div style="background: #f8d7da; border: 1px solid #f5c6cb; border-radius: 8px; padding: 1rem; text-align: center;">
                                                <i class="fas fa-times-circle" style="color: #dc3545; font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                                <div style="font-weight: 700; color: #721c24; margin-bottom: 0.25rem;">Konto wurde abgelehnt</div>
                                                <div style="font-size: 0.9rem; color: #856404;">
                                                    <a href="profile.php" style="color: #856404; text-decoration: underline;">Profil öffnen</a> und neues Dokument hochladen
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <div style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 1rem; text-align: center;">
                                                <i class="fas fa-hourglass-half" style="color: #ffc107; font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                                <div style="font-weight: 700; color: #856404; margin-bottom: 0.25rem;">Verifizierung erforderlich</div>
                                                <div style="font-size: 0.9rem; color: #856404;">
                                                    <a href="profile.php" style="color: #856404; text-decoration: underline;">Profil öffnen</a> und Dokument hochladen
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <a href="login.php?redirect=booking.php&event=<?php echo $event['id']; ?>" class="btn btn-primary event-btn">
                                        <i class="fas fa-sign-in-alt"></i>
                                        <span>Anmelden zum Buchen</span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
        <div class="section-container">
            <div class="section-header">
                <h2 class="section-title">Warum B&E Gruppe?</h2>
                <p class="section-subtitle">Professioneller Service für Ihren Volvo</p>
            </div>
            
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h3 class="feature-title">Professioneller Service</h3>
                    <p class="feature-description">
                        Schneller, präziser Reifenwechsel in nur 30 Minuten. 
                        Zertifizierte Volvo-Techniker sorgen für höchste Qualität.
                    </p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3 class="feature-title">Volvo Qualität</h3>
                    <p class="feature-description">
                        Original Volvo Teile und zertifizierte Techniker für maximale Sicherheit. 
                        Vertrauen Sie auf bewährte Volvo-Standards.
                    </p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <h3 class="feature-title">Terminvereinbarung</h3>
                    <p class="feature-description">
                        Einfache Online-Terminvereinbarung für Ihren Reifenwechsel. 
                        Komfortabel und zeitsparend.
                    </p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-warehouse"></i>
                    </div>
                    <h3 class="feature-title">Reifenlagerung</h3>
                    <p class="feature-description">
                        Sichere Einlagerung Ihrer Sommer- oder Winterreifen. 
                        Professionelle Lagerung in unserem klimatisierten Lager.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="cta-container">
            <div class="cta-content">
                <h2 class="cta-title">Bereit für Ihren Reifenwechsel?</h2>
                <p class="cta-description">
                    Buchen Sie jetzt Ihren Termin für einen professionellen Reifenwechsel-Service.
                </p>
                <a href="#events" class="btn btn-cta">
                    <i class="fas fa-calendar-plus"></i>
                    <span>Jetzt buchen</span>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-container">
            <div class="footer-content">
                <div class="footer-brand">
                    <div class="footer-logo">
                        <img src="<?php echo htmlspecialchars($companyLogo); ?>" alt="<?php echo htmlspecialchars($companyName); ?>" class="footer-logo-img">
                        <div class="footer-brand-text">
                            <h3><?php echo htmlspecialchars($appName); ?></h3>
                            <span>Volvo Service</span>
                        </div>
                    </div>
                    <p class="footer-description">
                        Ihr vertrauensvoller Partner für professionelle Reifenwechsel-Services. 
                        Qualität und Sicherheit für Ihren Volvo.
                    </p>
                </div>
                
                <div class="footer-links">
                    <div class="footer-column">
                        <h4 class="footer-title">Service</h4>
                        <ul class="footer-list">
                            <li><a href="#events">Events</a></li>
                            <li><a href="#booking">Termin buchen</a></li>
                            <li><a href="#services">Services</a></li>
                            <li><a href="#contact">Kontakt</a></li>
                        </ul>
                    </div>
                    
                    <div class="footer-column">
                        <h4 class="footer-title">Kontakt</h4>
                        <ul class="footer-list">
                            <li>
                                <i class="fas fa-phone"></i>
                                <span><?php echo htmlspecialchars($companyPhone); ?></span>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <span><?php echo htmlspecialchars($companyEmail); ?></span>
                            </li>
                            <li>
                                <i class="fas fa-map-marker-alt"></i>
                                <span><?php echo nl2br(htmlspecialchars($companyAddress)); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div class="footer-bottom">
                <div class="footer-bottom-content">
                    <p class="footer-copyright">
                        &copy; 2024 <?php echo htmlspecialchars($companyName); ?>. Alle Rechte vorbehalten.
                    </p>
                    <div class="footer-social">
                        <a href="#" class="social-link">
                            <i class="fab fa-facebook"></i>
                        </a>
                        <a href="#" class="social-link">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="#" class="social-link">
                            <i class="fab fa-linkedin"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="assets/js/main.js"></script>
    
    <script>
        // Autohaus-Auswahl Funktionen
        function selectAutohaus(autohausId, autohausName) {
            // Autohaus in Session speichern
            fetch('api/autohaus_selection.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    action: 'select_autohaus',
                    autohaus_id: autohausId,
                    autohaus_name: autohausName
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Events-Sektion anzeigen und nach Autohaus filtern
                    const eventsSection = document.getElementById('events-section');
                    eventsSection.style.display = 'block';
                    
                    // Warte kurz, dann filtere die Events
                    setTimeout(() => {
                        filterEventsByAutohaus(autohausId);
                    }, 100);
                    
                    // Autohaus-Auswahl-Sektion ausblenden
                    document.querySelector('.autohaus-selection-section').style.display = 'none';
                    
                    // Autohaus-Info in der Events-Sektion anzeigen
                    const eventsHeader = document.querySelector('#events-section .section-header');
                    const autohausInfo = document.createElement('div');
                    autohausInfo.className = 'selected-autohaus-info';
                    autohausInfo.innerHTML = `
                        <div class="autohaus-info-badge">
                            <i class="fas fa-building"></i>
                            <span>Ausgewähltes Autohaus: <strong>${autohausName}</strong></span>
                            <button type="button" onclick="changeAutohaus()" class="btn-change-autohaus">
                                <i class="fas fa-exchange-alt"></i> Wechseln
                            </button>
                        </div>
                    `;
                    eventsHeader.appendChild(autohausInfo);
                } else {
                    alert('Fehler bei der Autohaus-Auswahl: ' + data.error);
                }
            })
            .catch(error => {
                console.error('Fehler:', error);
                alert('Fehler bei der Autohaus-Auswahl');
            });
        }
        
        function filterEventsByAutohaus(autohausId = null) {
            const eventCards = document.querySelectorAll('.event-card');
            const filterSelect = document.getElementById('autohaus-filter');
            
            if (autohausId === null && filterSelect) {
                autohausId = filterSelect.value;
            }
            
            // Konvertiere autohausId zu String für Vergleich
            const targetAutohausId = String(autohausId);
            
            let visibleCount = 0;
            
            eventCards.forEach(card => {
                const cardAutohausId = card.getAttribute('data-autohaus-id');
                
                // Zeige alle Events wenn kein Filter gesetzt ist, oder zeige nur Events des gewählten Autohauses
                if (!targetAutohausId || targetAutohausId === '' || targetAutohausId === 'null' || cardAutohausId === targetAutohausId) {
                    card.style.display = 'block';
                    visibleCount++;
                } else {
                    card.style.display = 'none';
                }
            });
            
            // Debug-Information
            console.log('Filtering events for autohaus ID:', targetAutohausId);
            console.log('Found event cards:', eventCards.length);
            console.log('Visible event cards:', visibleCount);
            
            // Prüfe ob Events sichtbar sind
            if (visibleCount === 0) {
                console.log('No events visible for autohaus ID:', targetAutohausId);
                // Zeige eine Meldung wenn keine Events gefunden werden
                showNoEventsMessage(targetAutohausId);
            } else {
                hideNoEventsMessage();
            }
        }
        
        function showNoEventsMessage(autohausId) {
            // Entferne existierende Nachricht
            hideNoEventsMessage();
            
            const eventsGrid = document.querySelector('.events-grid');
            if (eventsGrid) {
                const noEventsDiv = document.createElement('div');
                noEventsDiv.className = 'no-events-message';
                noEventsDiv.innerHTML = `
                    <div class="no-events-icon">
                        <i class="fas fa-calendar-times"></i>
                    </div>
                    <h3>Keine Events verfügbar</h3>
                    <p>Für das ausgewählte Autohaus sind derzeit keine Events geplant.</p>
                    <p>Kontaktieren Sie uns für weitere Informationen.</p>
                `;
                eventsGrid.appendChild(noEventsDiv);
            }
        }
        
        function hideNoEventsMessage() {
            const existingMessage = document.querySelector('.no-events-message');
            if (existingMessage) {
                existingMessage.remove();
            }
        }
        
        function changeAutohaus() {
            // Zurück zur Autohaus-Auswahl
            document.querySelector('.autohaus-selection-section').style.display = 'block';
            document.getElementById('events-section').style.display = 'none';
            
            // Autohaus-Info entfernen
            const autohausInfo = document.querySelector('.selected-autohaus-info');
            if (autohausInfo) {
                autohausInfo.remove();
            }
        }
        
        // Event-Listener für Autohaus-Filter
        document.addEventListener('DOMContentLoaded', function() {
            const filterSelect = document.getElementById('autohaus-filter');
            if (filterSelect) {
                filterSelect.addEventListener('change', function() {
                    filterEventsByAutohaus();
                });
            }
            
            // Hero Slideshow initiieren
            initHeroSlideshow();
        });
        
        function initHeroSlideshow() {
            const slides = document.querySelectorAll('.hero-slideshow .slide');
            if (slides.length === 0) return;
            
            let currentSlide = 0;
            const totalSlides = slides.length;
            
            // Alle Slides initial ausblenden
            slides.forEach(slide => slide.classList.remove('active'));
            
            // Erstes Slide anzeigen
            if (slides.length > 0) {
                slides[0].classList.add('active');
            }
            
            // Automatischer Wechsel alle 5 Sekunden
            setInterval(() => {
                slides[currentSlide].classList.remove('active');
                currentSlide = (currentSlide + 1) % totalSlides;
                slides[currentSlide].classList.add('active');
            }, 5000);
        }
    </script>
</body>
</html>
