<?php
/**
 * Authentication Utility
 * Prüft ob User eingeloggt ist und verwaltet Session
 */

// Hilfsfunktion um sicherzustellen, dass Session gestartet ist
function ensureSession() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
}

function requireLogin() {
    ensureSession();
    
    // Prüfe ob User eingeloggt ist
    if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
        // Prüfe ob Token noch gültig ist (wenn vorhanden)
        if (isset($_SESSION['user_token'])) {
            require_once __DIR__ . '/../config/database.php';
            
            $db = new Database();
            $conn = $db->getConnection();
            
            $stmt = $conn->prepare("SELECT id FROM users WHERE auth_token = ? AND is_active = 1 AND token_expires_at > NOW()");
            $stmt->execute([$_SESSION['user_token']]);
            $user = $stmt->fetch();
            
            if (!$user) {
                // Token ungültig - Session zurücksetzen
                destroySession();
                header('Location: login.php');
                exit;
            }
        } else {
            // Kein Token vorhanden
            header('Location: login.php');
            exit;
        }
    }
}

function isLoggedIn() {
    ensureSession();
    return isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true;
}

function getCurrentUser() {
    ensureSession();
    
    if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
        return null;
    }
    
    if (!isset($_SESSION['user_id'])) {
        return null;
    }
    
    require_once __DIR__ . '/../config/database.php';
    
    $db = new Database();
    $conn = $db->getConnection();
    
    $stmt = $conn->prepare("SELECT * FROM users WHERE id = ? AND is_active = 1");
    $stmt->execute([$_SESSION['user_id']]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

function destroySession() {
    ensureSession();
    session_unset();
    session_destroy();
}

function logout() {
    destroySession();
    header('Location: login.php');
    exit;
}

function requireLoginRedirect($redirectUrl = 'login.php') {
    ensureSession();
    
    if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
        $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
        header('Location: ' . $redirectUrl);
        exit;
    }
    
    // Prüfe Verifizierungsstatus
    $user = getCurrentUser();
    if ($user) {
        if ($user['verification_status'] === 'pending') {
            header('Location: verification_pending.php');
            exit;
        }
        
        if ($user['verification_status'] === 'rejected') {
            header('Location: verification_pending.php');
            exit;
        }
    }
}

?>

