-- RESY Tire Data Tabelle für CSV-Import und Offline-Daten
-- Diese Tabelle speichert alle RESY-Daten für Offline-Zugriff

USE boxxenstopp;

CREATE TABLE IF NOT EXISTS resy_tire_data (
    id INT AUTO_INCREMENT PRIMARY KEY,
    einlagerungsnummer VARCHAR(50) UNIQUE NOT NULL,
    satznummer VARCHAR(50) NOT NULL,
    eingangsdatum DATE NOT NULL,
    serviceart VARCHAR(255) DEFAULT 'Lagern, Reinigen, Prüfen',
    autohaus_id INT,
    kennzeichen VARCHAR(20) NOT NULL,
    fin VARCHAR(50) NOT NULL,
    haltername VARCHAR(255) NOT NULL,
    fahrzeugtyp VARCHAR(255),
    baujahr VARCHAR(10),
    km_stand VARCHAR(20),
    
    -- Reifendaten als JSON gespeichert
    reifen_vl JSON,
    reifen_vr JSON,
    reifen_hl JSON,
    reifen_hr JSON,
    
    -- Bilder als JSON Array gespeichert
    images JSON,
    
    -- Zusätzliche Informationen
    bemerkung TEXT,
    
    -- Metadaten
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    -- Indizes
    INDEX idx_einlagerungsnummer (einlagerungsnummer),
    INDEX idx_kennzeichen (kennzeichen),
    INDEX idx_fin (fin),
    INDEX idx_autohaus (autohaus_id),
    INDEX idx_eingangsdatum (eingangsdatum),
    
    -- Foreign Key
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE SET NULL
);

-- Beispiel-Daten einfügen
INSERT INTO resy_tire_data (
    einlagerungsnummer, satznummer, eingangsdatum, serviceart, autohaus_id,
    kennzeichen, fin, haltername, fahrzeugtyp, baujahr, km_stand,
    reifen_vl, reifen_vr, reifen_hl, reifen_hr, bemerkung
) VALUES (
    '9.716.991',
    '9.716.991',
    '2025-03-27',
    'Lagern, Reinigen, Prüfen',
    1,
    'ECK-TE28E',
    'YV1LFH5V2P1964399',
    'Arte Agentur f. soz. Dienste UG',
    'Volvo XC90',
    '2022',
    '52.340 km',
    JSON_OBJECT(
        'position', 'VL',
        'marke', 'Pirelli',
        'modell', 'Scorpion Winter',
        'groesse', '275/35R22',
        'volltext', 'Pirelli Scorpion Winter 275/35R22 104V',
        'art', 'Winterreifen',
        'dot', '2722',
        'profiltiefe', JSON_OBJECT('i', '6.9', 'm', '6.9', 'a', '6.6'),
        'luftdruck', '2.6 bar',
        'empfehlung', 'keine Fehler',
        'zustand', 'Sehr gut'
    ),
    JSON_OBJECT(
        'position', 'VR',
        'marke', 'Pirelli',
        'modell', 'Scorpion Winter',
        'groesse', '275/35R22',
        'volltext', 'Pirelli Scorpion Winter 275/35R22 104V',
        'art', 'Winterreifen',
        'dot', '2722',
        'profiltiefe', JSON_OBJECT('i', '6.9', 'm', '6.9', 'a', '6.5'),
        'luftdruck', '2.6 bar',
        'empfehlung', 'leichte Fehler',
        'zustand', 'Befriedigend'
    ),
    JSON_OBJECT(
        'position', 'HL',
        'marke', 'Pirelli',
        'modell', 'Scorpion Winter',
        'groesse', '275/35R22',
        'volltext', 'Pirelli Scorpion Winter 275/35R22 104V',
        'art', 'Winterreifen',
        'dot', '2722',
        'profiltiefe', JSON_OBJECT('i', '6.8', 'm', '6.8', 'a', '6.8'),
        'luftdruck', '2.6 bar',
        'empfehlung', 'keine Fehler',
        'zustand', 'Sehr gut'
    ),
    JSON_OBJECT(
        'position', 'HR',
        'marke', 'Pirelli',
        'modell', 'Scorpion Winter',
        'groesse', '275/35R22',
        'volltext', 'Pirelli Scorpion Winter 275/35R22 104V',
        'art', 'Winterreifen',
        'dot', '2722',
        'profiltiefe', JSON_OBJECT('i', '6.7', 'm', '6.7', 'a', '6.7'),
        'luftdruck', '2.6 bar',
        'empfehlung', 'keine Fehler',
        'zustand', 'Sehr gut'
    ),
    'Beschädigung am Reifen VR vor der Montage prüfen; OJ 11.08.2025'
);

-- Weitere Beispiel-Daten
INSERT INTO resy_tire_data (
    einlagerungsnummer, satznummer, eingangsdatum, serviceart, autohaus_id,
    kennzeichen, fin, haltername, fahrzeugtyp, baujahr, km_stand,
    reifen_vl, reifen_vr, reifen_hl, reifen_hr
) VALUES (
    '9.716.669',
    '9.716.669',
    '2025-03-25',
    'Lagern, Reinigen, Prüfen',
    1,
    'K-CB2520',
    'YV1UZK5VCN1073102',
    'Care by Volvo Car Germany',
    'Volvo XC60 T8',
    '2023',
    '45.230 km',
    JSON_OBJECT(
        'position', 'VL',
        'marke', 'Dunlop',
        'modell', 'WINTER SPORT 5 SUV',
        'groesse', '235/55R19',
        'volltext', 'Dunlop WINTER SPORT 5 SUV 235/55R19 105V',
        'art', 'Winterreifen',
        'dot', '2921',
        'profiltiefe', JSON_OBJECT('i', '7.1', 'm', '6.9', 'a', '6.9'),
        'luftdruck', '2.5 bar',
        'empfehlung', 'keine Fehler',
        'zustand', 'Sehr gut'
    ),
    JSON_OBJECT(
        'position', 'VR',
        'marke', 'Dunlop',
        'modell', 'WINTER SPORT 5 SUV',
        'groesse', '235/55R19',
        'volltext', 'Dunlop WINTER SPORT 5 SUV 235/55R19 105V',
        'art', 'Winterreifen',
        'dot', '2921',
        'profiltiefe', JSON_OBJECT('i', '6.8', 'm', '6.6', 'a', '6.8'),
        'luftdruck', '2.5 bar',
        'empfehlung', 'keine Fehler',
        'zustand', 'Sehr gut'
    ),
    JSON_OBJECT(
        'position', 'HL',
        'marke', 'Dunlop',
        'modell', 'WINTER SPORT 5 SUV',
        'groesse', '235/55R19',
        'volltext', 'Dunlop WINTER SPORT 5 SUV 235/55R19 105V',
        'art', 'Winterreifen',
        'dot', '2921',
        'profiltiefe', JSON_OBJECT('i', '7.5', 'm', '7.5', 'a', '7.4'),
        'luftdruck', '2.5 bar',
        'empfehlung', 'keine Fehler',
        'zustand', 'Sehr gut'
    ),
    JSON_OBJECT(
        'position', 'HR',
        'marke', 'Dunlop',
        'modell', 'WINTER SPORT 5 SUV',
        'groesse', '235/55R19',
        'volltext', 'Dunlop WINTER SPORT 5 SUV 235/55R19 105V',
        'art', 'Winterreifen',
        'dot', '2921',
        'profiltiefe', JSON_OBJECT('i', '7.3', 'm', '7.1', 'a', '7.2'),
        'luftdruck', '2.5 bar',
        'empfehlung', 'keine Fehler',
        'zustand', 'Sehr gut'
    )
);
