-- 🗑️ REMOVE SCORING SYSTEM FROM DATABASE
-- Entfernt alle Scoring-bezogenen Tabellen, Prozeduren und Daten

USE boxxenstopp;

-- 1. Remove stored procedure for updating user score
DROP PROCEDURE IF EXISTS UpdateUserScore;

-- 2. Remove triggers that log activities (if they exist)
DROP TRIGGER IF EXISTS log_appointment_activity;
DROP TRIGGER IF EXISTS log_event_activity;

-- 3. Remove user activity log table (contains scoring-related data)
DROP TABLE IF EXISTS user_activity_log;

-- 4. Remove performance metrics cache table (contains scoring data)
DROP TABLE IF EXISTS performance_metrics_cache;

-- 5. Remove user preferences table (contains user_score data)
DROP TABLE IF EXISTS user_preferences;

-- 6. Remove dashboard stats view (contains scoring calculations)
DROP VIEW IF EXISTS dashboard_stats_view;

-- 7. Remove scoring-related data from user_dashboard_config
-- Update existing configs to remove scoring-related fields
UPDATE user_dashboard_config 
SET config_data = JSON_REMOVE(
    config_data,
    '$.scoring_enabled',
    '$.score_widget',
    '$.performance_tracking'
)
WHERE JSON_EXTRACT(config_data, '$.scoring_enabled') IS NOT NULL
   OR JSON_EXTRACT(config_data, '$.score_widget') IS NOT NULL
   OR JSON_EXTRACT(config_data, '$.performance_tracking') IS NOT NULL;

-- 8. Remove scoring-related widgets from dashboard_widgets
DELETE FROM dashboard_widgets 
WHERE widget_key IN (
    'user_score',
    'performance_metrics',
    'scoring_breakdown',
    'user_ranking',
    'activity_score'
);

-- 9. Remove scoring-related quick actions
DELETE FROM quick_actions 
WHERE title LIKE '%Score%' 
   OR title LIKE '%Punkte%'
   OR title LIKE '%Performance%'
   OR url LIKE '%score%'
   OR url LIKE '%scoring%';

-- 10. Clean up any remaining scoring references
-- Remove columns that might have been added for scoring
ALTER TABLE admin_users 
DROP COLUMN IF EXISTS user_score,
DROP COLUMN IF EXISTS performance_score,
DROP COLUMN IF EXISTS last_score_update;

-- 11. Remove any indexes related to scoring
DROP INDEX IF EXISTS idx_user_score ON admin_users;
DROP INDEX IF EXISTS idx_performance_score ON admin_users;
DROP INDEX IF EXISTS idx_user_activity_log_user_created ON user_activity_log;
DROP INDEX IF EXISTS idx_performance_metrics_cache_expires ON performance_metrics_cache;

-- 12. Show completion message
SELECT 'Scoring system removed successfully!' as message;

-- 13. Show remaining tables
SHOW TABLES;
