-- Tabelle für User-Fahrzeuge
-- Ermöglicht mehrere Fahrzeuge (Kennzeichen) pro Benutzer

CREATE TABLE IF NOT EXISTS user_vehicles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    license_plate VARCHAR(20) NOT NULL,
    vehicle_brand VARCHAR(100) NULL,
    vehicle_model VARCHAR(100) NULL,
    vehicle_year INT NULL,
    is_default BOOLEAN DEFAULT FALSE,
    is_active BOOLEAN DEFAULT TRUE,
    notes TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id),
    INDEX idx_license_plate (license_plate),
    INDEX idx_is_default (is_default)
);

-- Füge ein DEFAULT Kennzeichen für bestehende User hinzu (falls users-Tabelle bereits existiert)
-- Dies muss nur einmal ausgeführt werden
INSERT IGNORE INTO user_vehicles (user_id, license_plate, is_default)
SELECT id, license_plate, TRUE
FROM users
WHERE license_plate IS NOT NULL AND license_plate != '';

